/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.CachingValueExpressionEvaluatorFactory;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mapping.model.ValueExpressionParameterValueProvider;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.relational.core.conversion.AbstractRelationalConverter;
import org.springframework.data.relational.core.conversion.DocumentPropertyAccessor;
import org.springframework.data.relational.core.conversion.ObjectPath;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.conversion.RowDocumentAccessor;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.Embedded;
import org.springframework.data.relational.core.mapping.PersistentPropertyTranslator;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MappingRelationalConverter
extends AbstractRelationalConverter
implements ApplicationContextAware,
EnvironmentCapable {
    private SpELContext spELContext;
    @Nullable
    private Environment environment;
    private final ExpressionParser expressionParser = new SpelExpressionParser();
    private final SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory(this.expressionParser);
    private final EntityProjectionIntrospector introspector;
    private final CachingValueExpressionEvaluatorFactory valueExpressionEvaluatorFactory = new CachingValueExpressionEvaluatorFactory(this.expressionParser, (EnvironmentCapable)this, o -> this.spELContext.getEvaluationContext(o));

    public MappingRelationalConverter(RelationalMappingContext context) {
        super(context);
        this.spELContext = new SpELContext((PropertyAccessor)DocumentPropertyAccessor.INSTANCE);
        this.introspector = MappingRelationalConverter.createIntrospector((ProjectionFactory)this.projectionFactory, this.getConversions(), this.getMappingContext());
    }

    public MappingRelationalConverter(RelationalMappingContext context, CustomConversions conversions) {
        super(context, conversions);
        this.spELContext = new SpELContext((PropertyAccessor)DocumentPropertyAccessor.INSTANCE);
        this.introspector = MappingRelationalConverter.createIntrospector((ProjectionFactory)this.projectionFactory, this.getConversions(), this.getMappingContext());
    }

    private static EntityProjectionIntrospector createIntrospector(ProjectionFactory projectionFactory, CustomConversions conversions, MappingContext<?, ?> mappingContext) {
        return EntityProjectionIntrospector.create((ProjectionFactory)projectionFactory, (EntityProjectionIntrospector.ProjectionPredicate)EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().and((target, underlyingType) -> !conversions.isSimpleType(target)), mappingContext);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spELContext = new SpELContext(this.spELContext, (BeanFactory)applicationContext);
        this.environment = applicationContext.getEnvironment();
        this.projectionFactory.setBeanFactory((BeanFactory)applicationContext);
        this.projectionFactory.setBeanClassLoader(applicationContext.getClassLoader());
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = new StandardEnvironment();
        }
        return this.environment;
    }

    protected ConversionContext getConversionContext(ObjectPath path) {
        Assert.notNull((Object)path, (String)"ObjectPath must not be null");
        return new DefaultConversionContext(this, this.getConversions(), path, this::readAggregate, this::readCollectionOrArray, this::readMap, this::getPotentiallyConvertedSimpleRead);
    }

    @Override
    public <T> PersistentPropertyPathAccessor<T> getPropertyAccessor(PersistentEntity<T, ?> persistentEntity, T instance) {
        PersistentPropertyPathAccessor accessor = persistentEntity.getPropertyPathAccessor(instance);
        return new ConvertingPropertyAccessor((PersistentPropertyAccessor)accessor, this.getConversionService());
    }

    @Override
    public <M, D> EntityProjection<M, D> introspectProjection(Class<M> resultType, Class<D> entityType) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(entityType);
        if (persistentEntity == null && !resultType.isInterface() || ClassUtils.isAssignable(RowDocument.class, resultType)) {
            return EntityProjection.nonProjecting(resultType);
        }
        return this.introspector.introspect(resultType, entityType);
    }

    @Override
    public <R> R project(EntityProjection<R, ?> projection, RowDocument document) {
        if (!projection.isProjection()) {
            TypeInformation typeToRead = projection.getMappedType().getType().isInterface() ? projection.getDomainType() : projection.getMappedType();
            return (R)this.read(typeToRead, document);
        }
        ProjectingConversionContext context = this.newProjectingConversionContext(projection);
        return this.doReadProjection(context, document, projection);
    }

    protected <R> ProjectingConversionContext newProjectingConversionContext(EntityProjection<R, ?> projection) {
        return new ProjectingConversionContext(this, this.getConversions(), ObjectPath.ROOT, this::readCollectionOrArray, this::readMap, this::getPotentiallyConvertedSimpleRead, projection);
    }

    protected <R> R doReadProjection(ConversionContext context, RowDocument document, EntityProjection<R, ?> projection) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(projection.getActualDomainType());
        TypeInformation mappedType = projection.getActualMappedType();
        RelationalPersistentEntity mappedEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(mappedType);
        ValueExpressionEvaluator evaluator = this.valueExpressionEvaluatorFactory.create((Object)document);
        boolean isInterfaceProjection = mappedType.getType().isInterface();
        if (isInterfaceProjection) {
            PersistentPropertyTranslator propertyTranslator = PersistentPropertyTranslator.create(mappedEntity);
            RowDocumentAccessor documentAccessor = new RowDocumentAccessor(document);
            MapPersistentPropertyAccessor accessor = new MapPersistentPropertyAccessor();
            PersistentPropertyAccessor convertingAccessor = PropertyTranslatingPropertyAccessor.create(new ConvertingPropertyAccessor((PersistentPropertyAccessor)accessor, this.getConversionService()), propertyTranslator);
            RelationalPropertyValueProvider valueProvider = this.newValueProvider(documentAccessor, evaluator, context);
            this.readProperties(context, entity, convertingAccessor, documentAccessor, valueProvider, Predicates.isTrue());
            return (R)this.projectionFactory.createProjection(mappedType.getType(), accessor.getBean());
        }
        if (mappedEntity == null) {
            throw new MappingException(String.format("No mapping metadata found for %s", mappedType.getType().getName()));
        }
        final PersistentPropertyTranslator propertyTranslator = PersistentPropertyTranslator.create(entity, Predicates.negate(RelationalPersistentProperty::hasExplicitColumnName));
        RowDocumentAccessor documentAccessor = new RowDocumentAccessor(document){

            @Override
            String getColumnName(RelationalPersistentProperty prop) {
                return propertyTranslator.translate(prop).getColumnName().getReference();
            }
        };
        InstanceCreatorMetadata instanceCreatorMetadata = mappedEntity.getInstanceCreatorMetadata();
        ParameterValueProvider<RelationalPersistentProperty> provider = instanceCreatorMetadata != null && instanceCreatorMetadata.hasParameters() ? this.getParameterProvider(context, mappedEntity, documentAccessor, evaluator) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.getEntityInstantiators().getInstantiatorFor((PersistentEntity)mappedEntity);
        Object instance = instantiator.createInstance((PersistentEntity)mappedEntity, provider);
        return (R)this.populateProperties(context, mappedEntity, documentAccessor, evaluator, instance);
    }

    private Object doReadOrProject(ConversionContext context, RowDocument source, TypeInformation<?> typeHint, EntityProjection<?, ?> typeDescriptor) {
        if (typeDescriptor.isProjection()) {
            return this.doReadProjection(context, source, typeDescriptor);
        }
        return this.readAggregate(context, source, typeHint);
    }

    @Override
    public <R> R read(Class<R> type, RowDocument source) {
        return (R)this.read(TypeInformation.of(type), source);
    }

    protected <S> S read(TypeInformation<S> type, RowDocument source) {
        return this.readAggregate(this.getConversionContext(ObjectPath.ROOT), source, type);
    }

    protected <S> S readAggregate(ConversionContext context, RowDocument document, TypeInformation<? extends S> typeHint) {
        return this.readAggregate(context, new RowDocumentAccessor(document), typeHint);
    }

    protected <S> S readAggregate(ConversionContext context, RowDocumentAccessor documentAccessor, TypeInformation<? extends S> typeHint) {
        Class rawType = typeHint.getType();
        if (this.getConversions().hasCustomReadTarget(RowDocument.class, rawType)) {
            return (S)this.doConvert(documentAccessor.getDocument(), rawType, typeHint.getType());
        }
        if (RowDocument.class.isAssignableFrom(rawType)) {
            return (S)documentAccessor.getDocument();
        }
        if (typeHint.isMap()) {
            return context.convert(documentAccessor, typeHint);
        }
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(typeHint);
        if (entity == null) {
            throw new MappingException(String.format("Expected to read Document %s into type %s but didn't find a PersistentEntity for the latter", documentAccessor, rawType));
        }
        return this.read(context, entity, documentAccessor);
    }

    protected Map<Object, Object> readMap(ConversionContext context, Map<?, ?> source, TypeInformation<?> targetType) {
        Assert.notNull(source, (String)"Document must not be null");
        Assert.notNull(targetType, (String)"TypeInformation must not be null");
        Class mapType = targetType.getType();
        TypeInformation keyType = targetType.getComponentType();
        TypeInformation valueType = targetType.getMapValueType() == null ? TypeInformation.OBJECT : targetType.getRequiredMapValueType();
        Class rawKeyType = keyType != null ? keyType.getType() : Object.class;
        Map map = CollectionFactory.createMap((Class)mapType, (Class)rawKeyType, (int)source.keySet().size());
        source.forEach((k, v) -> {
            Object key = k;
            if (!rawKeyType.isAssignableFrom(key.getClass())) {
                key = this.doConvert(key, rawKeyType);
            }
            map.put(key, v == null ? v : context.convert(v, valueType));
        });
        return map;
    }

    protected Object readCollectionOrArray(ConversionContext context, Collection<?> source, TypeInformation<?> targetType) {
        Collection<?> items;
        Assert.notNull(targetType, (String)"Target type must not be null");
        Class collectionType = targetType.isSubTypeOf(Collection.class) ? targetType.getType() : List.class;
        TypeInformation componentType = targetType.getComponentType() != null ? targetType.getComponentType() : TypeInformation.OBJECT;
        Class rawComponentType = componentType.getType();
        Collection collection = items = targetType.getType().isArray() ? new ArrayList(source.size()) : CollectionFactory.createCollection((Class)collectionType, (Class)rawComponentType, (int)source.size());
        if (source.isEmpty()) {
            return this.getPotentiallyConvertedSimpleRead(items, targetType);
        }
        for (Object element : source) {
            items.add(element != null ? context.convert(element, componentType) : element);
        }
        return this.getPotentiallyConvertedSimpleRead(items, targetType);
    }

    private <T> T doConvert(Object value, Class<? extends T> target) {
        return this.doConvert(value, target, null);
    }

    private <T> T doConvert(Object value, Class<? extends T> target, @Nullable Class<? extends T> fallback) {
        if (this.getConversionService().canConvert(value.getClass(), target) || fallback == null) {
            return (T)this.getConversionService().convert(value, target);
        }
        return (T)this.getConversionService().convert(value, fallback);
    }

    private <S> S read(ConversionContext context, RelationalPersistentEntity<S> entity, RowDocumentAccessor documentAccessor) {
        ValueExpressionEvaluator evaluator = this.valueExpressionEvaluatorFactory.create((Object)documentAccessor.getDocument());
        InstanceCreatorMetadata instanceCreatorMetadata = entity.getInstanceCreatorMetadata();
        ParameterValueProvider<RelationalPersistentProperty> provider = instanceCreatorMetadata != null && instanceCreatorMetadata.hasParameters() ? this.getParameterProvider(context, entity, documentAccessor, evaluator) : NoOpParameterValueProvider.INSTANCE;
        EntityInstantiator instantiator = this.getEntityInstantiators().getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, provider);
        return (S)this.populateProperties(context, entity, documentAccessor, evaluator, instance);
    }

    @Override
    public <T> T createInstance(PersistentEntity<T, RelationalPersistentProperty> entity, Function<Parameter<?, RelationalPersistentProperty>, Object> parameterValueProvider) {
        return (T)this.getEntityInstantiators().getInstantiatorFor(entity).createInstance(entity, new ConvertingParameterValueProvider(parameterValueProvider));
    }

    private ParameterValueProvider<RelationalPersistentProperty> getParameterProvider(final ConversionContext context, RelationalPersistentEntity<?> entity, final RowDocumentAccessor source, final ValueExpressionEvaluator evaluator) {
        RelationalPropertyValueProvider contextualizing = new RelationalPropertyValueProvider(){

            @Override
            public boolean hasValue(RelationalPersistentProperty property) {
                return this.withContext(context.forProperty(property)).hasValue(property);
            }

            @Override
            public boolean hasNonEmptyValue(RelationalPersistentProperty property) {
                return this.withContext(context.forProperty(property)).hasNonEmptyValue(property);
            }

            @Nullable
            public <T> T getPropertyValue(RelationalPersistentProperty property) {
                ConversionContext propertyContext = context.forProperty(property);
                RelationalPropertyValueProvider provider = this.withContext(propertyContext);
                if (property.isEmbedded()) {
                    return (T)MappingRelationalConverter.this.readEmbedded(propertyContext, provider, source, property, (RelationalPersistentEntity)MappingRelationalConverter.this.getMappingContext().getRequiredPersistentEntity(property));
                }
                return (T)provider.getPropertyValue(property);
            }

            @Override
            public RelationalPropertyValueProvider withContext(ConversionContext context2) {
                return MappingRelationalConverter.this.newValueProvider(source, evaluator, context2);
            }
        };
        PersistentEntityParameterValueProvider parameterProvider = new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)contextualizing, context.getPath().getCurrentObject());
        return new ConverterAwareExpressionParameterValueProvider(context, evaluator, this.getConversionService(), new ConvertingParameterValueProvider<RelationalPersistentProperty>(arg_0 -> ((PersistentEntityParameterValueProvider)parameterProvider).getParameterValue(arg_0)));
    }

    private <S> S populateProperties(ConversionContext context, RelationalPersistentEntity<S> entity, RowDocumentAccessor documentAccessor, ValueExpressionEvaluator evaluator, S instance) {
        if (!entity.requiresPropertyPopulation()) {
            return instance;
        }
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), this.getConversionService());
        ObjectPath currentPath = context.getPath().push(accessor.getBean(), entity);
        ConversionContext contextToUse = context.withPath(currentPath);
        RelationalPropertyValueProvider valueProvider = this.newValueProvider(documentAccessor, evaluator, contextToUse);
        Predicate<RelationalPersistentProperty> propertyFilter = MappingRelationalConverter.isConstructorArgument(entity).negate();
        this.readProperties(contextToUse, entity, (PersistentPropertyAccessor<?>)accessor, documentAccessor, valueProvider, propertyFilter);
        return (S)accessor.getBean();
    }

    protected RelationalPropertyValueProvider newValueProvider(RowDocumentAccessor documentAccessor, ValueExpressionEvaluator evaluator, ConversionContext context) {
        return new DocumentValueProvider(context, documentAccessor, evaluator, this.spELContext);
    }

    private void readProperties(ConversionContext context, RelationalPersistentEntity<?> entity, PersistentPropertyAccessor<?> accessor, RowDocumentAccessor documentAccessor, RelationalPropertyValueProvider valueProvider, Predicate<RelationalPersistentProperty> propertyFilter) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)iterator.next();
            if (!propertyFilter.test(property)) continue;
            ConversionContext propertyContext = context.forProperty(property);
            RelationalPropertyValueProvider valueProviderToUse = valueProvider.withContext(propertyContext);
            if (property.isEmbedded()) {
                accessor.setProperty((PersistentProperty)property, this.readEmbedded(propertyContext, valueProviderToUse, documentAccessor, property, (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(property)));
                continue;
            }
            if (!valueProviderToUse.hasValue(property)) continue;
            accessor.setProperty((PersistentProperty)property, valueProviderToUse.getPropertyValue(property));
        }
    }

    @Nullable
    private Object readEmbedded(ConversionContext conversionContext, RelationalPropertyValueProvider provider, RowDocumentAccessor source, RelationalPersistentProperty property, RelationalPersistentEntity<?> persistentEntity) {
        if (this.shouldReadEmbeddable(conversionContext, property, persistentEntity, provider)) {
            return this.read(conversionContext, persistentEntity, source);
        }
        return null;
    }

    private boolean shouldReadEmbeddable(ConversionContext context, RelationalPersistentProperty property, RelationalPersistentEntity<?> unwrappedEntity, RelationalPropertyValueProvider propertyValueProvider) {
        Embedded.OnEmpty onEmpty = ((Embedded)property.getRequiredAnnotation(Embedded.class)).onEmpty();
        if (onEmpty.equals((Object)Embedded.OnEmpty.USE_EMPTY)) {
            return true;
        }
        Iterator iterator = unwrappedEntity.iterator();
        while (iterator.hasNext()) {
            RelationalPersistentEntity nestedEntity;
            RelationalPersistentProperty persistentProperty = (RelationalPersistentProperty)iterator.next();
            ConversionContext nestedContext = context.forProperty(persistentProperty);
            RelationalPropertyValueProvider contextual = propertyValueProvider.withContext(nestedContext);
            if (!(persistentProperty.isEmbedded() ? this.shouldReadEmbeddable(nestedContext, persistentProperty, nestedEntity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(persistentProperty), contextual) : contextual.hasNonEmptyValue(persistentProperty))) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Object readValue(@Nullable Object value, TypeInformation<?> type) {
        if (null == value) {
            return null;
        }
        return this.getPotentiallyConvertedSimpleRead(value, type);
    }

    @Nullable
    private Object getPotentiallyConvertedSimpleWrite(Object value) {
        Optional customTarget = this.getConversions().getCustomWriteTarget(value.getClass());
        if (customTarget.isPresent()) {
            return this.getConversionService().convert(value, (Class)customTarget.get());
        }
        return Enum.class.isAssignableFrom(value.getClass()) ? ((Enum)value).name() : value;
    }

    protected Object getPotentiallyConvertedSimpleRead(Object value, TypeInformation<?> type) {
        Class target = type.getType();
        if (this.getConversions().hasCustomReadTarget(value.getClass(), target)) {
            return this.getConversionService().convert(value, TypeDescriptor.forObject((Object)value), MappingRelationalConverter.createTypeDescriptor(type));
        }
        if (ClassUtils.isAssignableValue((Class)target, (Object)value)) {
            return value;
        }
        if (Enum.class.isAssignableFrom(target) && value instanceof CharSequence) {
            return Enum.valueOf(target, value.toString());
        }
        return this.getConversionService().convert(value, TypeDescriptor.forObject((Object)value), MappingRelationalConverter.createTypeDescriptor(type));
    }

    private static TypeDescriptor createTypeDescriptor(TypeInformation<?> type) {
        List typeArguments = type.getTypeArguments();
        Class[] generics = new Class[typeArguments.size()];
        for (int i = 0; i < typeArguments.size(); ++i) {
            generics[i] = ((TypeInformation)typeArguments.get(i)).getType();
        }
        return new TypeDescriptor(ResolvableType.forClassWithGenerics((Class)type.getType(), (Class[])generics), type.getType(), null);
    }

    @Override
    @Nullable
    public Object writeValue(@Nullable Object value, TypeInformation<?> type) {
        RelationalPersistentEntity persistentEntity;
        if (value == null) {
            return null;
        }
        if (this.getConversions().isSimpleType(value.getClass())) {
            Optional customWriteTarget;
            Optional optional = customWriteTarget = this.getConversions().hasCustomWriteTarget(value.getClass(), type.getType()) ? this.getConversions().getCustomWriteTarget(value.getClass(), type.getType()) : this.getConversions().getCustomWriteTarget(type.getType());
            if (customWriteTarget.isPresent()) {
                return this.getConversionService().convert(value, (Class)customWriteTarget.get());
            }
            if (TypeInformation.OBJECT != type) {
                if (type.getType().isAssignableFrom(value.getClass())) {
                    if (value.getClass().isEnum()) {
                        return this.getPotentiallyConvertedSimpleWrite(value);
                    }
                    return value;
                }
                if (this.getConversionService().canConvert(value.getClass(), type.getType())) {
                    value = this.getConversionService().convert(value, type.getType());
                }
            }
            return this.getPotentiallyConvertedSimpleWrite(value);
        }
        if (value.getClass().isArray()) {
            return this.writeArray(value, type);
        }
        if (value instanceof Collection) {
            return this.writeCollection((Iterable)value, type);
        }
        if (this.getMappingContext().hasPersistentEntityFor(value.getClass()) && (persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getPersistentEntity(value.getClass())) != null) {
            Object id = persistentEntity.getIdentifierAccessor(value).getIdentifier();
            return this.writeValue(id, type);
        }
        return this.getConversionService().convert(value, type.getType());
    }

    private Object writeArray(Object value, TypeInformation<?> type) {
        Class<?> componentType = value.getClass().getComponentType();
        Optional optionalWriteTarget = this.getConversions().getCustomWriteTarget(componentType);
        if (optionalWriteTarget.isEmpty() && !componentType.isEnum()) {
            return value;
        }
        Class customWriteTarget = optionalWriteTarget.orElseGet(() -> componentType.isEnum() ? String.class : componentType);
        if (customWriteTarget.equals(componentType)) {
            return value;
        }
        TypeInformation component = TypeInformation.OBJECT;
        if (type.isCollectionLike() && type.getActualType() != null) {
            component = type.getRequiredComponentType();
        }
        int length = Array.getLength(value);
        Object target = Array.newInstance(customWriteTarget, length);
        for (int i = 0; i < length; ++i) {
            Array.set(target, i, this.writeValue(Array.get(value, i), component));
        }
        return target;
    }

    private Object writeCollection(Iterable<?> value, TypeInformation<?> type) {
        ArrayList<Object> mapped = new ArrayList<Object>();
        TypeInformation component = TypeInformation.OBJECT;
        if (type.isCollectionLike() && type.getActualType() != null) {
            component = type.getRequiredComponentType();
        }
        for (Object o : value) {
            mapped.add(this.writeValue(o, component));
        }
        if (type.getType().isInstance(mapped) || !type.isCollectionLike()) {
            return mapped;
        }
        return this.getConversionService().convert(mapped, type.getType());
    }

    static Predicate<RelationalPersistentProperty> isConstructorArgument(PersistentEntity<?, ?> entity) {
        return arg_0 -> entity.isCreatorArgument(arg_0);
    }

    protected static class DefaultConversionContext
    implements ConversionContext {
        final RelationalConverter sourceConverter;
        final CustomConversions conversions;
        final ObjectPath objectPath;
        final ContainerValueConverter<RowDocument> documentConverter;
        final ContainerValueConverter<Collection<?>> collectionConverter;
        final ContainerValueConverter<Map<?, ?>> mapConverter;
        final ValueConverter<Object> elementConverter;

        protected DefaultConversionContext(RelationalConverter sourceConverter, CustomConversions customConversions, ObjectPath objectPath, ContainerValueConverter<RowDocument> documentConverter, ContainerValueConverter<Collection<?>> collectionConverter, ContainerValueConverter<Map<?, ?>> mapConverter, ValueConverter<Object> elementConverter) {
            this.sourceConverter = sourceConverter;
            this.conversions = customConversions;
            this.objectPath = objectPath;
            this.documentConverter = documentConverter;
            this.collectionConverter = collectionConverter;
            this.mapConverter = mapConverter;
            this.elementConverter = elementConverter;
        }

        @Override
        public <S> S convert(Object source, TypeInformation<? extends S> typeHint, ConversionContext context) {
            Assert.notNull((Object)source, (String)"Source must not be null");
            Assert.notNull(typeHint, (String)"TypeInformation must not be null");
            if (this.conversions.hasCustomReadTarget(source.getClass(), typeHint.getType())) {
                return (S)this.elementConverter.convert(source, typeHint);
            }
            if (source instanceof Collection) {
                Collection collection = (Collection)source;
                if (typeHint.isCollectionLike() || typeHint.getType().isAssignableFrom(Collection.class)) {
                    return (S)this.collectionConverter.convert(context, collection, typeHint);
                }
            }
            if (typeHint.isMap()) {
                if (ClassUtils.isAssignable(RowDocument.class, (Class)typeHint.getType())) {
                    return (S)this.documentConverter.convert(context, (RowDocument)source, typeHint);
                }
                if (source instanceof Map) {
                    Map map = (Map)source;
                    return (S)this.mapConverter.convert(context, map, typeHint);
                }
                throw new IllegalArgumentException(String.format("Expected map like structure but found %s", source.getClass()));
            }
            if (source instanceof RowDocument) {
                RowDocument document = (RowDocument)source;
                return (S)this.documentConverter.convert(context, document, typeHint);
            }
            return (S)this.elementConverter.convert(source, typeHint);
        }

        @Override
        public ConversionContext withPath(ObjectPath currentPath) {
            Assert.notNull((Object)currentPath, (String)"ObjectPath must not be null");
            return new DefaultConversionContext(this.sourceConverter, this.conversions, currentPath, this.documentConverter, this.collectionConverter, this.mapConverter, this.elementConverter);
        }

        @Override
        public ObjectPath getPath() {
            return this.objectPath;
        }

        @Override
        public CustomConversions getCustomConversions() {
            return this.conversions;
        }

        @Override
        public RelationalConverter getSourceConverter() {
            return this.sourceConverter;
        }

        protected static interface ContainerValueConverter<T> {
            public Object convert(ConversionContext var1, T var2, TypeInformation<?> var3);
        }

        protected static interface ValueConverter<T> {
            public Object convert(T var1, TypeInformation<?> var2);
        }
    }

    protected class ProjectingConversionContext
    extends DefaultConversionContext {
        private final EntityProjection<?, ?> returnedTypeDescriptor;

        protected ProjectingConversionContext(RelationalConverter sourceConverter, CustomConversions customConversions, ObjectPath path, DefaultConversionContext.ContainerValueConverter<Collection<?>> collectionConverter, DefaultConversionContext.ContainerValueConverter<Map<?, ?>> mapConverter, DefaultConversionContext.ValueConverter<Object> elementConverter, EntityProjection<?, ?> projection) {
            super(sourceConverter, customConversions, path, (context, source, typeHint) -> MappingRelationalConverter.this.doReadOrProject(context, (RowDocument)source, (TypeInformation<?>)typeHint, projection), collectionConverter, mapConverter, elementConverter);
            this.returnedTypeDescriptor = projection;
        }

        @Override
        public ConversionContext forProperty(String name) {
            EntityProjection property = this.returnedTypeDescriptor.findProperty(name);
            if (property == null) {
                return new DefaultConversionContext(this.sourceConverter, this.conversions, this.objectPath, MappingRelationalConverter.this::readAggregate, this.collectionConverter, this.mapConverter, this.elementConverter);
            }
            return new ProjectingConversionContext(this.sourceConverter, this.conversions, this.objectPath, this.collectionConverter, this.mapConverter, this.elementConverter, property);
        }

        @Override
        public ConversionContext withPath(ObjectPath currentPath) {
            return new ProjectingConversionContext(this.sourceConverter, this.conversions, currentPath, this.collectionConverter, this.mapConverter, this.elementConverter, this.returnedTypeDescriptor);
        }
    }

    protected static interface ConversionContext {
        default public <S> S convert(Object source, TypeInformation<? extends S> typeHint) {
            return this.convert(source, typeHint, this);
        }

        public <S> S convert(Object var1, TypeInformation<? extends S> var2, ConversionContext var3);

        default public ConversionContext forProperty(String name) {
            return this;
        }

        default public ConversionContext forProperty(RelationalPersistentProperty property) {
            return this.forProperty(property.getName());
        }

        public ConversionContext withPath(ObjectPath var1);

        public ObjectPath getPath();

        public CustomConversions getCustomConversions();

        public RelationalConverter getSourceConverter();
    }

    static class MapPersistentPropertyAccessor
    implements PersistentPropertyAccessor<Map<String, Object>> {
        Map<String, Object> map = new LinkedHashMap<String, Object>();

        MapPersistentPropertyAccessor() {
        }

        public void setProperty(PersistentProperty<?> persistentProperty, Object o) {
            this.map.put(persistentProperty.getName(), o);
        }

        public Object getProperty(PersistentProperty<?> persistentProperty) {
            return this.map.get(persistentProperty.getName());
        }

        public Map<String, Object> getBean() {
            return this.map;
        }
    }

    private record PropertyTranslatingPropertyAccessor<T>(PersistentPropertyAccessor<T> delegate, PersistentPropertyTranslator propertyTranslator) implements PersistentPropertyAccessor<T>
    {
        static <T> PersistentPropertyAccessor<T> create(PersistentPropertyAccessor<T> delegate, PersistentPropertyTranslator propertyTranslator) {
            return new PropertyTranslatingPropertyAccessor<T>(delegate, propertyTranslator);
        }

        public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
            this.delegate.setProperty((PersistentProperty)this.translate(property), value);
        }

        public Object getProperty(PersistentProperty<?> property) {
            return this.delegate.getProperty((PersistentProperty)this.translate(property));
        }

        public T getBean() {
            return (T)this.delegate.getBean();
        }

        private RelationalPersistentProperty translate(PersistentProperty<?> property) {
            return this.propertyTranslator.translate((RelationalPersistentProperty)property);
        }
    }

    protected static interface RelationalPropertyValueProvider
    extends PropertyValueProvider<RelationalPersistentProperty> {
        public boolean hasValue(RelationalPersistentProperty var1);

        public boolean hasNonEmptyValue(RelationalPersistentProperty var1);

        public RelationalPropertyValueProvider withContext(ConversionContext var1);
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<RelationalPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(Parameter<T, RelationalPersistentProperty> parameter) {
            return null;
        }
    }

    class ConvertingParameterValueProvider<P extends PersistentProperty<P>>
    implements ParameterValueProvider<P> {
        private final Function<Parameter<?, P>, Object> delegate;

        ConvertingParameterValueProvider(Function<Parameter<?, P>, Object> delegate) {
            Assert.notNull(delegate, (String)"Delegate must not be null");
            this.delegate = delegate;
        }

        public <T> T getParameterValue(Parameter<T, P> parameter) {
            return (T)MappingRelationalConverter.this.readValue(this.delegate.apply(parameter), parameter.getType());
        }
    }

    private static class ConverterAwareExpressionParameterValueProvider
    extends ValueExpressionParameterValueProvider<RelationalPersistentProperty> {
        private final ConversionContext context;

        public ConverterAwareExpressionParameterValueProvider(ConversionContext context, ValueExpressionEvaluator evaluator, ConversionService conversionService, ParameterValueProvider<RelationalPersistentProperty> delegate) {
            super(evaluator, conversionService, delegate);
            Assert.notNull((Object)context, (String)"ConversionContext must no be null");
            this.context = context;
        }

        protected <T> T potentiallyConvertExpressionValue(Object object, Parameter<T, RelationalPersistentProperty> parameter) {
            return (T)this.context.convert(object, parameter.getType());
        }
    }

    protected static final class DocumentValueProvider
    implements RelationalPropertyValueProvider,
    AggregatePathValueProvider {
        private final ConversionContext context;
        private final RowDocumentAccessor accessor;
        private final ValueExpressionEvaluator evaluator;
        private final SpELContext spELContext;
        private final RowDocument document;

        private DocumentValueProvider(ConversionContext context, RowDocumentAccessor accessor, ValueExpressionEvaluator evaluator, SpELContext spELContext) {
            Assert.notNull((Object)context, (String)"ConversionContext must no be null");
            Assert.notNull((Object)accessor, (String)"DocumentAccessor must no be null");
            Assert.notNull((Object)evaluator, (String)"ValueExpressionEvaluator must not be null");
            this.context = context;
            this.accessor = accessor;
            this.evaluator = evaluator;
            this.spELContext = spELContext;
            this.document = accessor.getDocument();
        }

        @Nullable
        public <T> T getPropertyValue(RelationalPersistentProperty property) {
            Object value;
            String expression = property.getSpelExpression();
            Object object = value = expression != null ? this.evaluator.evaluate(expression) : this.accessor.get(property);
            if (value == null) {
                return null;
            }
            ConversionContext contextToUse = this.context.forProperty(property);
            return (T)contextToUse.convert(value, property.getTypeInformation());
        }

        @Override
        public boolean hasValue(RelationalPersistentProperty property) {
            return this.accessor.hasValue(property);
        }

        @Override
        public boolean hasNonEmptyValue(RelationalPersistentProperty property) {
            return this.hasValue(property);
        }

        @Override
        @Nullable
        public Object getValue(AggregatePath path) {
            Object value = this.document.get(path.getColumnInfo().alias().getReference());
            if (value == null) {
                return null;
            }
            return this.context.convert(value, path.getRequiredLeafProperty().getTypeInformation());
        }

        @Override
        public boolean hasValue(AggregatePath path) {
            Object value = this.document.get(path.getColumnInfo().alias().getReference());
            if (value == null) {
                return false;
            }
            if (!path.isCollectionLike()) {
                return true;
            }
            return true;
        }

        @Override
        public boolean hasNonEmptyValue(AggregatePath path) {
            if (!this.hasValue(path)) {
                return false;
            }
            Object value = this.document.get(path.getColumnInfo().alias().getReference());
            if (value instanceof Collection || value.getClass().isArray()) {
                return !ObjectUtils.isEmpty((Object)value);
            }
            return true;
        }

        @Override
        public boolean hasValue(SqlIdentifier identifier) {
            return this.document.get(identifier.getReference()) != null;
        }

        @Override
        public DocumentValueProvider withContext(ConversionContext context) {
            return context == this.context ? this : new DocumentValueProvider(context, this.accessor, this.evaluator, this.spELContext);
        }
    }

    protected static interface AggregatePathValueProvider
    extends RelationalPropertyValueProvider {
        public boolean hasValue(AggregatePath var1);

        public boolean hasNonEmptyValue(AggregatePath var1);

        public boolean hasValue(SqlIdentifier var1);

        @Nullable
        public Object getValue(AggregatePath var1);

        @Override
        public AggregatePathValueProvider withContext(ConversionContext var1);
    }
}

