/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import org.springframework.core.MethodParameter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.util.UriUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ResourceMetadataHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final Repositories repositories;
    private final ResourceMappings mappings;
    private final BaseUri baseUri;

    public ResourceMetadataHandlerMethodArgumentResolver(Repositories repositories, ResourceMappings mappings, BaseUri baseUri) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null");
        Assert.notNull((Object)baseUri, (String)"BaseUri must not be null");
        this.repositories = repositories;
        this.mappings = mappings;
        this.baseUri = baseUri;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable((Class)parameter.getParameterType(), ResourceMetadata.class);
    }

    public ResourceMetadata resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String lookupPath = this.baseUri.getRepositoryLookupPath(webRequest);
        String repositoryKey = UriUtils.findMappingVariable("repository", parameter.getMethod(), lookupPath);
        if (!StringUtils.hasText((String)repositoryKey)) {
            return null;
        }
        for (Class domainType : this.repositories) {
            ResourceMetadata mapping = this.mappings.getMetadataFor(domainType);
            if (!mapping.getPath().matches(repositoryKey) || !mapping.isExported()) continue;
            return mapping;
        }
        throw new HttpClientErrorException((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

