/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.webmvc.AbstractGraphQlHttpHandler;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.IdGenerator;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GraphQlSseHandler
extends AbstractGraphQlHttpHandler {
    private final IdGenerator idGenerator = new AlternativeJdkIdGenerator();

    public GraphQlSseHandler(WebGraphQlHandler graphQlHandler) {
        super(graphQlHandler, null);
    }

    @Override
    protected ServerResponse prepareResponse(ServerRequest request, Mono<WebGraphQlResponse> responseMono) {
        Flux resultFlux = responseMono.flatMapMany(response -> {
            if (response.getData() instanceof Publisher) {
                Publisher publisher = (Publisher)response.getData();
                return Flux.from((Publisher)publisher).map(ExecutionResult::toSpecification);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("A subscription DataFetcher must return a Publisher: " + response.getData()));
            }
            return Flux.just((Object)ExecutionResult.newExecutionResult().addError(GraphQLError.newError().errorType((ErrorClassification)ErrorType.OperationNotSupported).message("SSE handler supports only subscriptions", new Object[0]).build()).build().toSpecification());
        });
        return ServerResponse.sse(SseSubscriber.connect((Flux<Map<String, Object>>)resultFlux));
    }

    private static final class SseSubscriber
    extends BaseSubscriber<Map<String, Object>> {
        private final ServerResponse.SseBuilder sseBuilder;

        private SseSubscriber(ServerResponse.SseBuilder sseBuilder) {
            this.sseBuilder = sseBuilder;
        }

        protected void hookOnNext(Map<String, Object> value) {
            this.writeResult(value);
        }

        private void writeResult(Map<String, Object> value) {
            try {
                this.sseBuilder.event("next");
                this.sseBuilder.data(value);
            }
            catch (IOException exception) {
                this.onError(exception);
            }
        }

        protected void hookOnError(Throwable ex) {
            if (ex instanceof SubscriptionPublisherException) {
                SubscriptionPublisherException spe = (SubscriptionPublisherException)((Object)ex);
                ExecutionResult result = ExecutionResult.newExecutionResult().errors(spe.getErrors()).build();
                this.writeResult(result.toSpecification());
            } else {
                this.sseBuilder.error(ex);
            }
            this.hookOnComplete();
        }

        protected void hookOnComplete() {
            try {
                this.sseBuilder.event("complete").data((Object)"");
            }
            catch (IOException exc) {
                throw new RuntimeException(exc);
            }
            this.sseBuilder.complete();
        }

        static Consumer<ServerResponse.SseBuilder> connect(Flux<Map<String, Object>> resultFlux) {
            return sseBuilder -> {
                SseSubscriber subscriber = new SseSubscriber((ServerResponse.SseBuilder)sseBuilder);
                resultFlux.subscribe((CoreSubscriber)subscriber);
            };
        }
    }
}

