/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import com.netflix.graphql.dgs.client.codegen.BaseProjectionNode;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import com.netflix.graphql.dgs.client.codegen.GraphQLQueryRequest;
import graphql.schema.Coercing;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.graphql.client.ClientGraphQlResponse;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DgsGraphQlClient {
    private final GraphQlClient graphQlClient;

    private DgsGraphQlClient(GraphQlClient graphQlClient) {
        this.graphQlClient = graphQlClient;
    }

    public GraphQlClient getGraphQlClient() {
        return this.graphQlClient;
    }

    public RequestSpec request(GraphQLQuery query) {
        return new RequestSpec(query);
    }

    public static DgsGraphQlClient create(GraphQlClient client) {
        return new DgsGraphQlClient(client);
    }

    public final class RequestSpec {
        private final GraphQLQuery query;
        @Nullable
        private BaseProjectionNode projectionNode;
        @Nullable
        private Map<Class<?>, Coercing<?, ?>> coercingMap;
        @Nullable
        private Map<String, Object> attributes;

        private RequestSpec(GraphQLQuery query) {
            Assert.notNull((Object)query, (String)"Expected GraphQLQuery");
            this.query = query;
        }

        public RequestSpec projection(BaseProjectionNode projectionNode) {
            this.projectionNode = projectionNode;
            return this;
        }

        public RequestSpec coercing(Class<?> scalarType, Coercing<?, ?> coercing) {
            this.coercingMap = this.coercingMap != null ? this.coercingMap : new LinkedHashMap();
            this.coercingMap.put(scalarType, coercing);
            return this;
        }

        public RequestSpec coercing(Map<Class<?>, Coercing<?, ?>> coercingMap) {
            this.coercingMap = this.coercingMap != null ? this.coercingMap : new LinkedHashMap();
            this.coercingMap.putAll(coercingMap);
            return this;
        }

        public RequestSpec attribute(String name, Object value) {
            this.attributes = this.attributes != null ? this.attributes : new HashMap<String, Object>();
            this.attributes.put(name, value);
            return this;
        }

        public RequestSpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            this.attributes = this.attributes != null ? this.attributes : new HashMap<String, Object>();
            attributesConsumer.accept(this.attributes);
            return this;
        }

        public GraphQlClient.RetrieveSyncSpec retrieveSync() {
            return this.initRequestSpec().retrieveSync(this.getDefaultPath());
        }

        public GraphQlClient.RetrieveSyncSpec retrieveSync(String path) {
            return this.initRequestSpec().retrieveSync(path);
        }

        public GraphQlClient.RetrieveSpec retrieve() {
            return this.initRequestSpec().retrieve(this.getDefaultPath());
        }

        public GraphQlClient.RetrieveSpec retrieve(String path) {
            return this.initRequestSpec().retrieve(path);
        }

        public GraphQlClient.RetrieveSubscriptionSpec retrieveSubscription() {
            return this.initRequestSpec().retrieveSubscription(this.getDefaultPath());
        }

        public ClientGraphQlResponse executeSync() {
            return this.initRequestSpec().executeSync();
        }

        public Mono<ClientGraphQlResponse> execute() {
            return this.initRequestSpec().execute();
        }

        public Flux<ClientGraphQlResponse> executeSubscription() {
            return this.initRequestSpec().executeSubscription();
        }

        private GraphQlClient.RequestSpec initRequestSpec() {
            Assert.state((this.projectionNode != null || this.coercingMap == null ? 1 : 0) != 0, (String)"Coercing map provided without projection");
            GraphQLQueryRequest request = this.coercingMap != null ? new GraphQLQueryRequest(this.query, this.projectionNode, this.coercingMap) : new GraphQLQueryRequest(this.query, this.projectionNode);
            String operationName = this.query.getName() != null ? this.query.getName() : null;
            return DgsGraphQlClient.this.graphQlClient.document(request.serialize()).operationName(operationName).attributes(map -> {
                if (this.attributes != null) {
                    map.putAll(this.attributes);
                }
            });
        }

        private String getDefaultPath() {
            return this.query.getOperationName();
        }
    }
}

