/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.MediaTypes;
import org.springframework.graphql.client.ResponseMapGraphQlResponse;
import org.springframework.graphql.client.SyncGraphQlTransport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClient;

final class HttpSyncGraphQlTransport
implements SyncGraphQlTransport {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final RestClient restClient;
    private final MediaType contentType;

    HttpSyncGraphQlTransport(RestClient restClient) {
        Assert.notNull((Object)restClient, (String)"RestClient is required");
        this.restClient = restClient;
        this.contentType = HttpSyncGraphQlTransport.initContentType(restClient);
    }

    private static MediaType initContentType(RestClient webClient) {
        HttpHeaders headers = new HttpHeaders();
        webClient.mutate().defaultHeaders(arg_0 -> ((HttpHeaders)headers).putAll(arg_0));
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType : MediaType.APPLICATION_JSON;
    }

    @Override
    public GraphQlResponse execute(GraphQlRequest request) {
        Map<String, Object> body = (Map<String, Object>)((RestClient.RequestBodySpec)this.restClient.post().contentType(this.contentType).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaTypes.APPLICATION_GRAPHQL_RESPONSE})).body(request.toMap()).exchange((httpRequest, httpResponse) -> {
            if (httpResponse.getStatusCode().equals(HttpStatus.OK)) {
                return (Map)httpResponse.bodyTo(MAP_TYPE);
            }
            if (httpResponse.getStatusCode().is4xxClientError() && HttpSyncGraphQlTransport.isGraphQlResponse((ClientHttpResponse)httpResponse)) {
                return (Map)httpResponse.bodyTo(MAP_TYPE);
            }
            if (httpResponse.getStatusCode().is4xxClientError()) {
                throw HttpClientErrorException.create((String)httpResponse.getStatusText(), (HttpStatusCode)httpResponse.getStatusCode(), (String)httpResponse.getStatusText(), (HttpHeaders)httpResponse.getHeaders(), (byte[])HttpSyncGraphQlTransport.getBody((HttpInputMessage)httpResponse), (Charset)HttpSyncGraphQlTransport.getCharset((HttpMessage)httpResponse));
            }
            throw HttpServerErrorException.create((String)httpResponse.getStatusText(), (HttpStatusCode)httpResponse.getStatusCode(), (String)httpResponse.getStatusText(), (HttpHeaders)httpResponse.getHeaders(), (byte[])HttpSyncGraphQlTransport.getBody((HttpInputMessage)httpResponse), (Charset)HttpSyncGraphQlTransport.getCharset((HttpMessage)httpResponse));
        });
        return new ResponseMapGraphQlResponse(body != null ? body : Collections.emptyMap());
    }

    private static boolean isGraphQlResponse(ClientHttpResponse clientResponse) {
        return MediaTypes.APPLICATION_GRAPHQL_RESPONSE.isCompatibleWith(clientResponse.getHeaders().getContentType());
    }

    private static byte[] getBody(HttpInputMessage message) {
        try {
            return FileCopyUtils.copyToByteArray((InputStream)message.getBody());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    @Nullable
    private static Charset getCharset(HttpMessage response) {
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

