/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import io.micrometer.context.ContextSnapshot;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.execution.ContextPropagationHelper;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public abstract class SubscriptionExceptionResolverAdapter
implements SubscriptionExceptionResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean threadLocalContextAware;

    public void setThreadLocalContextAware(boolean threadLocalContextAware) {
        this.threadLocalContextAware = threadLocalContextAware;
    }

    public boolean isThreadLocalContextAware() {
        return this.threadLocalContextAware;
    }

    @Override
    public final Mono<List<GraphQLError>> resolveException(Throwable exception) {
        if (this.threadLocalContextAware) {
            return Mono.deferContextual(contextView -> {
                ContextSnapshot snapshot = ContextPropagationHelper.captureFrom(contextView);
                try {
                    List errors = (List)snapshot.wrap(() -> this.resolveToMultipleErrors(exception)).call();
                    return Mono.justOrEmpty((Object)errors);
                }
                catch (Exception ex2) {
                    this.logger.warn((Object)("Failed to resolve " + String.valueOf(exception)), (Throwable)ex2);
                    return Mono.empty();
                }
            });
        }
        return Mono.justOrEmpty(this.resolveToMultipleErrors(exception));
    }

    @Nullable
    protected List<GraphQLError> resolveToMultipleErrors(Throwable exception) {
        GraphQLError error = this.resolveToSingleError(exception);
        return error != null ? Collections.singletonList(error) : null;
    }

    @Nullable
    protected GraphQLError resolveToSingleError(Throwable exception) {
        return null;
    }
}

