/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import java.util.List;
import java.util.Map;
import org.springframework.graphql.MediaTypes;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.webflux.AbstractGraphQlHttpHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.NotAcceptableStatusException;
import reactor.core.publisher.Mono;

public class GraphQlHttpHandler
extends AbstractGraphQlHttpHandler {
    private static final MediaType APPLICATION_GRAPHQL = new MediaType("application", "graphql+json");
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = List.of(MediaTypes.APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, APPLICATION_GRAPHQL);
    private boolean httpOkOnValidationErrors = false;

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        super(graphQlHandler, null);
    }

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler, CodecConfigurer codecConfigurer) {
        super(graphQlHandler, codecConfigurer);
    }

    public boolean isHttpOkOnValidationErrors() {
        return this.httpOkOnValidationErrors;
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public void setHttpOkOnValidationErrors(boolean httpOkOnValidationErrors) {
        this.httpOkOnValidationErrors = httpOkOnValidationErrors;
    }

    @Override
    protected Mono<ServerResponse> prepareResponse(ServerRequest request, WebGraphQlResponse response) {
        MediaType responseMediaType = GraphQlHttpHandler.selectResponseMediaType(request);
        HttpStatus responseStatus = this.selectResponseStatus(response, responseMediaType);
        ServerResponse.BodyBuilder builder = ServerResponse.status((HttpStatusCode)responseStatus);
        builder.headers(headers -> headers.putAll((Map)response.getResponseHeaders()));
        builder.contentType(responseMediaType);
        return builder.bodyValue(this.encodeResponseIfNecessary(response));
    }

    protected HttpStatus selectResponseStatus(WebGraphQlResponse response, MediaType responseMediaType) {
        if (!this.isHttpOkOnValidationErrors() && !response.getExecutionResult().isDataPresent() && MediaTypes.APPLICATION_GRAPHQL_RESPONSE.equals((Object)responseMediaType)) {
            return HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.OK;
    }

    private static MediaType selectResponseMediaType(ServerRequest serverRequest) {
        List acceptedMediaTypes;
        ServerRequest.Headers headers = serverRequest.headers();
        try {
            acceptedMediaTypes = headers.accept();
        }
        catch (InvalidMediaTypeException ex) {
            throw new NotAcceptableStatusException("Could not parse Accept header [" + headers.firstHeader("Accept") + "]: " + ex.getMessage());
        }
        for (MediaType accepted : acceptedMediaTypes) {
            if (!SUPPORTED_MEDIA_TYPES.contains(accepted)) continue;
            return accepted;
        }
        return MediaType.APPLICATION_JSON;
    }
}

