/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DummyInvocationUtils {
    private static final ThreadLocal<Map<CacheKey<?>, Object>> CACHE = ThreadLocal.withInitial(HashMap::new);

    public static <T> T methodOn(Class<T> type, Object ... parameters) {
        Assert.notNull(type, (String)"Given type must not be null!");
        return (T)CACHE.get().computeIfAbsent(CacheKey.of(type, parameters), it -> {
            InvocationRecordingMethodInterceptor interceptor = new InvocationRecordingMethodInterceptor(((CacheKey)it).type, ((CacheKey)it).arguments);
            return DummyInvocationUtils.getProxyWithInterceptor(((CacheKey)it).type, interceptor, type.getClassLoader());
        });
    }

    @Nullable
    public static LastInvocationAware getLastInvocationAware(Object source) {
        if (InvocationRecordingMethodInterceptor.class.isInstance(source)) {
            return (LastInvocationAware)LastInvocationAware.class.cast(source);
        }
        return (LastInvocationAware)(Advised.class.isInstance(source) ? ((Advised)source).getAdvisors()[0].getAdvice() : source);
    }

    private static <T> T getProxyWithInterceptor(Class<?> type, InvocationRecordingMethodInterceptor interceptor, ClassLoader classLoader) {
        if (type.equals(Object.class)) {
            return (T)interceptor;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.addAdvice((Advice)interceptor);
        factory.addInterface(LastInvocationAware.class);
        if (type.isInterface()) {
            factory.addInterface(type);
        } else {
            factory.setOptimize(true);
            factory.setTargetClass(type);
            factory.setProxyTargetClass(true);
        }
        return (T)factory.getProxy(classLoader);
    }

    private static final class SimpleMethodInvocation
    implements MethodInvocation {
        private final Class<?> targetType;
        private final Method method;
        private final Object[] arguments;

        public SimpleMethodInvocation(Class<?> targetType, Method method, Object[] arguments) {
            Assert.notNull(targetType, (String)"targetType must not be null!");
            Assert.notNull((Object)method, (String)"method must not be null!");
            Assert.notNull((Object)arguments, (String)"arguments must not be null!");
            this.targetType = targetType;
            this.method = method;
            this.arguments = arguments;
        }

        @Override
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SimpleMethodInvocation)) {
                return false;
            }
            SimpleMethodInvocation that = (SimpleMethodInvocation)o;
            return Objects.equals(this.targetType, that.targetType) && Objects.equals(this.method, that.method) && Arrays.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            int result = Objects.hash(this.targetType, this.method);
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }

        public String toString() {
            return "DummyInvocationUtils.SimpleMethodInvocation(targetType=" + this.targetType + ", method=" + this.method + ", arguments=" + Arrays.deepToString(this.arguments) + ")";
        }
    }

    private static final class CacheKey<T> {
        private final Class<T> type;
        private final Object[] arguments;

        private CacheKey(Class<T> type, Object[] arguments) {
            this.type = type;
            this.arguments = arguments;
        }

        public static <T> CacheKey<T> of(Class<T> type, Object[] arguments) {
            return new CacheKey<T>(type, arguments);
        }

        public Class<T> getType() {
            return this.type;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.type, cacheKey.type) && Arrays.equals(this.arguments, cacheKey.arguments);
        }

        public int hashCode() {
            int result = Objects.hash(this.type);
            result = 31 * result + Arrays.hashCode(this.arguments);
            return result;
        }

        public String toString() {
            return "DummyInvocationUtils.CacheKey(type=" + this.type + ", arguments=" + Arrays.deepToString(this.arguments) + ")";
        }
    }

    private static class InvocationRecordingMethodInterceptor
    implements MethodInterceptor,
    LastInvocationAware {
        private final Class<?> targetType;
        private final Object[] objectParameters;
        private MethodInvocation invocation;

        InvocationRecordingMethodInterceptor(Class<?> targetType, Object ... parameters) {
            Assert.notNull(targetType, (String)"Target type must not be null!");
            Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
            this.targetType = targetType;
            this.objectParameters = (Object[])parameters.clone();
        }

        @Nullable
        public Object invoke(org.aopalliance.intercept.MethodInvocation invocation) {
            Method method = invocation.getMethod();
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)invocation.getThis(), (Object[])invocation.getArguments());
            }
            this.invocation = new SimpleMethodInvocation(this.targetType, method, invocation.getArguments());
            Class<?> returnType = method.getReturnType();
            ClassLoader classLoader = method.getDeclaringClass().getClassLoader();
            return returnType.cast(DummyInvocationUtils.getProxyWithInterceptor(returnType, this, classLoader));
        }

        @Override
        public MethodInvocation getLastInvocation() {
            return this.invocation;
        }

        @Override
        public Iterator<Object> getObjectParameters() {
            return Arrays.asList(this.objectParameters).iterator();
        }
    }
}

