/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PagedModel<T>
extends CollectionModel<T> {
    public static PagedModel<?> NO_PAGE = new PagedModel();
    private PageMetadata metadata;

    protected PagedModel() {
        this(new ArrayList(), (PageMetadata)null, new Link[0]);
    }

    @Deprecated
    public PagedModel(Collection<T> content, @Nullable PageMetadata metadata, Link ... links) {
        this(content, metadata, Arrays.asList(links));
    }

    @Deprecated
    public PagedModel(Collection<T> content, @Nullable PageMetadata metadata, Iterable<Link> links) {
        super(content, links);
        this.metadata = metadata;
    }

    public static <T> PagedModel<T> empty() {
        return PagedModel.empty(Collections.emptyList());
    }

    public static <T> PagedModel<T> empty(Link ... links) {
        return PagedModel.empty((PageMetadata)null, links);
    }

    public static <T> PagedModel<T> empty(Iterable<Link> links) {
        return PagedModel.empty((PageMetadata)null, links);
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata) {
        return PagedModel.empty(metadata, Collections.emptyList());
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata, Link ... links) {
        return PagedModel.empty(Arrays.asList(links));
    }

    public static <T> PagedModel<T> empty(@Nullable PageMetadata metadata, Iterable<Link> links) {
        return PagedModel.of(Collections.emptyList(), metadata, links);
    }

    public static <T> PagedModel<T> of(Collection<T> content, @Nullable PageMetadata metadata) {
        return new PagedModel<T>(content, metadata, new Link[0]);
    }

    public static <T> PagedModel<T> of(Collection<T> content, @Nullable PageMetadata metadata, Link ... links) {
        return new PagedModel<T>(content, metadata, Arrays.asList(links));
    }

    public static <T> PagedModel<T> of(Collection<T> content, @Nullable PageMetadata metadata, Iterable<Link> links) {
        return new PagedModel<T>(content, metadata, links);
    }

    @JsonProperty(value="page")
    @Nullable
    public PageMetadata getMetadata() {
        return this.metadata;
    }

    public static <T extends EntityModel<S>, S> PagedModel<T> wrap(Iterable<S> content, PageMetadata metadata) {
        Assert.notNull(content, (String)"Content must not be null!");
        ArrayList<EntityModel<S>> resources = new ArrayList<EntityModel<S>>();
        for (S element : content) {
            resources.add(EntityModel.of(element));
        }
        return PagedModel.of(resources, metadata);
    }

    @JsonIgnore
    public Optional<Link> getNextLink() {
        return this.getLink(IanaLinkRelations.NEXT);
    }

    @JsonIgnore
    public Optional<Link> getPreviousLink() {
        return this.getLink(IanaLinkRelations.PREV);
    }

    @Override
    public String toString() {
        return String.format("PagedModel { content: %s, metadata: %s, links: %s }", this.getContent(), this.metadata, this.getLinks());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PagedModel that = (PagedModel)obj;
        boolean metadataEquals = this.metadata == null ? that.metadata == null : this.metadata.equals(that.metadata);
        return metadataEquals && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.metadata == null ? 0 : 31 * this.metadata.hashCode();
    }

    public static class PageMetadata {
        @JsonProperty
        private long size;
        @JsonProperty
        private long totalElements;
        @JsonProperty
        private long totalPages;
        @JsonProperty
        private long number;

        protected PageMetadata() {
        }

        public PageMetadata(long size, long number, long totalElements, long totalPages) {
            Assert.isTrue((size > -1L ? 1 : 0) != 0, (String)"Size must not be negative!");
            Assert.isTrue((number > -1L ? 1 : 0) != 0, (String)"Number must not be negative!");
            Assert.isTrue((totalElements > -1L ? 1 : 0) != 0, (String)"Total elements must not be negative!");
            Assert.isTrue((totalPages > -1L ? 1 : 0) != 0, (String)"Total pages must not be negative!");
            this.size = size;
            this.number = number;
            this.totalElements = totalElements;
            this.totalPages = totalPages;
        }

        public PageMetadata(long size, long number, long totalElements) {
            this(size, number, totalElements, size == 0L ? 0L : (long)Math.ceil((double)totalElements / (double)size));
        }

        public long getSize() {
            return this.size;
        }

        public long getTotalElements() {
            return this.totalElements;
        }

        public long getTotalPages() {
            return this.totalPages;
        }

        public long getNumber() {
            return this.number;
        }

        public String toString() {
            return String.format("Metadata { number: %d, total pages: %d, total elements: %d, size: %d }", this.number, this.totalPages, this.totalElements, this.size);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            PageMetadata that = (PageMetadata)obj;
            return this.number == that.number && this.size == that.size && this.totalElements == that.totalElements && this.totalPages == that.totalPages;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * (int)(this.number ^ this.number >>> 32);
            result += 31 * (int)(this.size ^ this.size >>> 32);
            result += 31 * (int)(this.totalElements ^ this.totalElements >>> 32);
            return result += 31 * (int)(this.totalPages ^ this.totalPages >>> 32);
        }
    }
}

