/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.config.HypermediaMappingInformationComparator;
import org.springframework.hateoas.config.WebfluxCodecCustomizer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@Configuration(proxyBeanMethods=false)
class WebFluxHateoasConfiguration {
    WebFluxHateoasConfiguration() {
    }

    @Bean
    HypermediaWebFluxConfigurer hypermediaWebFluxConfigurer(ObjectProvider<ObjectMapper> mapper, List<HypermediaMappingInformation> mappingInformation, Optional<HypermediaMappingInformationComparator> comparator) {
        comparator.ifPresent(mappingInformation::sort);
        WebfluxCodecCustomizer customizer = new WebfluxCodecCustomizer(mappingInformation, (ObjectMapper)mapper.getIfAvailable(ObjectMapper::new));
        return new HypermediaWebFluxConfigurer(customizer);
    }

    @Bean
    @Lazy
    ServerWebExchangeContextFilter serverWebExchangeContextFilter() {
        return new ServerWebExchangeContextFilter();
    }

    static class HypermediaWebFluxConfigurer
    implements WebFluxConfigurer {
        private final WebfluxCodecCustomizer customizer;

        public HypermediaWebFluxConfigurer(WebfluxCodecCustomizer customizer) {
            this.customizer = customizer;
        }

        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            configurer.defaultCodecs().configureDefaultCodec((Consumer)this.customizer);
        }
    }
}

