/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.json.JacksonJsonDecoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import tools.jackson.databind.json.JsonMapper;

public class HypermediaWebTestClientConfigurer
implements WebTestClientConfigurer {
    private Consumer<ClientCodecConfigurer> configurer;

    HypermediaWebTestClientConfigurer(JsonMapper mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        Assert.notNull((Object)mapper, (String)"mapper must not be null!");
        Assert.notNull(hypermediaTypes, (String)"hypermediaTypes must not be null!");
        this.configurer = clientCodecConfigurer -> hypermediaTypes.forEach(hypermediaType -> {
            JsonMapper customized = hypermediaType.configureJsonMapper(mapper.rebuild()).build();
            MimeType[] mimeTypes = hypermediaType.getMediaTypes().toArray(new MimeType[0]);
            clientCodecConfigurer.customCodecs().registerWithDefaultConfig((Object)new JacksonJsonEncoder(customized, mimeTypes));
            clientCodecConfigurer.customCodecs().registerWithDefaultConfig((Object)new JacksonJsonDecoder(customized, mimeTypes));
        });
    }

    public void afterConfigurerAdded(WebTestClient.Builder builder, @Nullable WebHttpHandlerBuilder webHttpHandlerBuilder, @Nullable ClientHttpConnector clientHttpConnector) {
        builder.codecs(this.configurer);
    }
}

