/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationCustomizer;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationFactory;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalJacksonModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsJacksonModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsLinkDiscoverer;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplatePropertyWriter;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.http.MediaType;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.json.JsonMapper;

@Configuration(proxyBeanMethods=false)
class HalFormsMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final DelegatingLinkRelationProvider relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final MediaTypeConfigurationFactory<HalFormsConfiguration, ? extends MediaTypeConfigurationCustomizer<HalFormsConfiguration>> configurationFactory;
    private final MessageResolver resolver;
    private final AbstractAutowireCapableBeanFactory beanFactory;

    public HalFormsMediaTypeConfiguration(DelegatingLinkRelationProvider relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<MediaTypeConfigurationCustomizer<HalConfiguration>> halCustomizers, ObjectProvider<HalFormsConfiguration> halFormsConfiguration, ObjectProvider<MediaTypeConfigurationCustomizer<HalFormsConfiguration>> halFormsCustomizers, MessageResolver resolver, AbstractAutowireCapableBeanFactory beanFactory) {
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        Supplier<HalFormsConfiguration> defaultConfig = () -> {
            MediaTypeConfigurationFactory customizedHalConfiguration = new MediaTypeConfigurationFactory(() -> (HalConfiguration)halConfiguration.getIfAvailable(HalConfiguration::new), halCustomizers);
            return new HalFormsConfiguration(customizedHalConfiguration.getConfiguration());
        };
        this.configurationFactory = new MediaTypeConfigurationFactory<HalFormsConfiguration, MediaTypeConfigurationCustomizer<HalFormsConfiguration>>(() -> (HalFormsConfiguration)halFormsConfiguration.getIfAvailable(defaultConfig), halFormsCustomizers);
        this.resolver = resolver;
        this.beanFactory = beanFactory;
    }

    @Bean
    LinkDiscoverer halFormsLinkDiscoverer() {
        return new HalFormsLinkDiscoverer();
    }

    @Bean
    HalFormsTemplateBuilder halFormsTemplateBuilder() {
        HalFormsConfiguration configuration = this.configurationFactory.getConfiguration();
        return new HalFormsTemplateBuilder(configuration, this.resolver);
    }

    @Bean
    HalFormsTemplatePropertyWriter halFormsTemplatePropertyWriter(HalFormsTemplateBuilder builder) {
        return new HalFormsTemplatePropertyWriter(builder);
    }

    @Override
    public JsonMapper.Builder configureJsonMapper(JsonMapper.Builder builder) {
        HalFormsConfiguration halFormsConfig = this.configurationFactory.getConfiguration();
        CurieProvider provider = (CurieProvider)this.curieProvider.getIfAvailable(() -> CurieProvider.NONE);
        builder = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)builder.disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).addModule((JacksonModule)new HalFormsJacksonModule())).handlerInstantiator((HandlerInstantiator)new HalJacksonModule.HalHandlerInstantiator(this.relProvider, provider, this.resolver, halFormsConfig.getHalConfiguration(), (AutowireCapableBeanFactory)this.beanFactory));
        return halFormsConfig.customize(builder);
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return this.configurationFactory.getConfiguration().getMediaTypes();
    }

    HalFormsConfiguration getResolvedConfiguration() {
        return this.configurationFactory.getConfiguration();
    }
}

