/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jms;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.jms.ChannelPublishingJmsMessageListener;
import org.springframework.integration.jms.JmsMessageDrivenEndpoint;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.messaging.MessageChannel;

public class JmsInboundGateway
extends MessagingGatewaySupport
implements OrderlyShutdownCapable {
    private final JmsMessageDrivenEndpoint endpoint;

    public JmsInboundGateway(AbstractMessageListenerContainer listenerContainer, ChannelPublishingJmsMessageListener listener) {
        this.endpoint = new JmsMessageDrivenEndpoint(listenerContainer, listener);
    }

    public void setRequestChannel(MessageChannel requestChannel) {
        super.setRequestChannel(requestChannel);
        this.endpoint.setOutputChannel(requestChannel);
    }

    public void setRequestChannelName(String requestChannelName) {
        super.setRequestChannelName(requestChannelName);
        this.endpoint.setOutputChannelName(requestChannelName);
    }

    public void setReplyChannel(MessageChannel replyChannel) {
        super.setReplyChannel(replyChannel);
        this.endpoint.getListener().setReplyChannel(replyChannel);
    }

    public void setReplyChannelName(String replyChannelName) {
        super.setReplyChannelName(replyChannelName);
        this.endpoint.getListener().setReplyChannelName(replyChannelName);
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        super.setErrorChannel(errorChannel);
        this.endpoint.setErrorChannel(errorChannel);
    }

    public void setErrorChannelName(String errorChannelName) {
        super.setErrorChannelName(errorChannelName);
        this.endpoint.setErrorChannelName(errorChannelName);
    }

    public void setRequestTimeout(long requestTimeout) {
        super.setRequestTimeout(requestTimeout);
        this.endpoint.setSendTimeout(requestTimeout);
    }

    public void setReplyTimeout(long replyTimeout) {
        super.setReplyTimeout(replyTimeout);
        this.endpoint.getListener().setReplyTimeout(replyTimeout);
    }

    public void setShouldTrack(boolean shouldTrack) {
        super.setShouldTrack(shouldTrack);
        this.endpoint.setShouldTrack(shouldTrack);
    }

    public void setShutdownContainerOnStop(boolean shutdownContainerOnStop) {
        this.endpoint.setShutdownContainerOnStop(shutdownContainerOnStop);
    }

    public String getComponentType() {
        return this.endpoint.getComponentType();
    }

    public void setComponentName(String componentName) {
        super.setComponentName(componentName);
        this.endpoint.setComponentName(this.getComponentName());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.endpoint.setApplicationContext(applicationContext);
        this.endpoint.setBeanFactory((BeanFactory)applicationContext);
        this.endpoint.getListener().setBeanFactory((BeanFactory)applicationContext);
    }

    protected void onInit() {
        this.endpoint.afterPropertiesSet();
    }

    public ChannelPublishingJmsMessageListener getListener() {
        return this.endpoint.getListener();
    }

    protected void doStart() {
        super.doStart();
        this.endpoint.start();
    }

    protected void doStop() {
        super.doStop();
        this.endpoint.stop();
    }

    public void destroy() {
        this.endpoint.destroy();
        try {
            super.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public int beforeShutdown() {
        return this.endpoint.beforeShutdown();
    }

    public int afterShutdown() {
        return this.endpoint.afterShutdown();
    }
}

