/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.core;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.jpa.core.AbstractJpaOperations;
import org.springframework.integration.jpa.core.JpaOperationFailedException;
import org.springframework.integration.jpa.support.JpaUtils;
import org.springframework.integration.jpa.support.parametersource.ParameterSource;
import org.springframework.integration.jpa.support.parametersource.PositionSupportingParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultJpaOperations
extends AbstractJpaOperations {
    private static final LogAccessor LOGGER = new LogAccessor(DefaultJpaOperations.class);

    @Override
    public void delete(Object entity) {
        Assert.notNull((Object)entity, (String)"The entity must not be null!");
        this.getEntityManager().remove(entity);
    }

    @Override
    public void deleteInBatch(Iterable<?> entities) {
        Assert.notNull(entities, (String)"entities must not be null.");
        Iterator<?> iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Class<?> entityClass = null;
        for (Object object : entities) {
            if (entityClass == null) {
                entityClass = object.getClass();
                continue;
            }
            if (entityClass == object.getClass()) continue;
            throw new IllegalArgumentException("entities must be of the same type.");
        }
        EntityManager entityManager = this.getEntityManager();
        String entityName = JpaUtils.getEntityName(entityManager, entityClass);
        String queryString = JpaUtils.getQueryString("delete from %s x", entityName);
        JpaUtils.applyAndBind(queryString, entities, entityManager).executeUpdate();
    }

    @Override
    public int executeUpdate(String updateQuery, ParameterSource source) {
        Query query = this.getEntityManager().createQuery(updateQuery);
        this.setParametersIfRequired(updateQuery, source, query);
        return query.executeUpdate();
    }

    @Override
    public int executeUpdateWithNamedQuery(String updateQuery, ParameterSource source) {
        Query query = this.getEntityManager().createNamedQuery(updateQuery);
        this.setParametersIfRequired(updateQuery, source, query);
        return query.executeUpdate();
    }

    @Override
    public int executeUpdateWithNativeQuery(String updateQuery, ParameterSource source) {
        Query query = this.getEntityManager().createNativeQuery(updateQuery);
        this.setParametersIfRequired(updateQuery, source, query);
        return query.executeUpdate();
    }

    @Override
    public <T> T find(Class<T> entityType, Object id) {
        return (T)this.getEntityManager().find(entityType, id);
    }

    private Query getQuery(String queryString, ParameterSource source) {
        Query query = this.getEntityManager().createQuery(queryString);
        this.setParametersIfRequired(queryString, source, query);
        return query;
    }

    @Override
    public List<?> getResultListForClass(Class<?> entityClass, int firstResult, int maxNumberOfResults) {
        String entityName = JpaUtils.getEntityName(this.getEntityManager(), entityClass);
        TypedQuery query = this.getEntityManager().createQuery("select x from " + entityName + " x", entityClass);
        if (firstResult > 0) {
            query.setFirstResult(firstResult);
        }
        if (maxNumberOfResults > 0) {
            query.setMaxResults(maxNumberOfResults);
        }
        return query.getResultList();
    }

    @Override
    public List<?> getResultListForNamedQuery(String selectNamedQuery, ParameterSource parameterSource, int firstResult, int maxNumberOfResults) {
        Query query = this.getEntityManager().createNamedQuery(selectNamedQuery);
        this.setParametersIfRequired(selectNamedQuery, parameterSource, query);
        if (firstResult > 0) {
            query.setFirstResult(firstResult);
        }
        if (maxNumberOfResults > 0) {
            query.setMaxResults(maxNumberOfResults);
        }
        return query.getResultList();
    }

    @Override
    public List<?> getResultListForNativeQuery(String selectQuery, @Nullable Class<?> entityClass, ParameterSource parameterSource, int firstResult, int maxNumberOfResults) {
        Query query = entityClass == null ? this.getEntityManager().createNativeQuery(selectQuery) : this.getEntityManager().createNativeQuery(selectQuery, entityClass);
        this.setParametersIfRequired(selectQuery, parameterSource, query);
        if (firstResult > 0) {
            query.setFirstResult(firstResult);
        }
        if (maxNumberOfResults > 0) {
            query.setMaxResults(maxNumberOfResults);
        }
        return query.getResultList();
    }

    @Override
    public List<?> getResultListForQuery(String query, ParameterSource source) {
        return this.getResultListForQuery(query, source, 0, 0);
    }

    @Override
    public List<?> getResultListForQuery(String queryString, ParameterSource source, int firstResult, int maxNumberOfResults) {
        Query query = this.getQuery(queryString, source);
        if (firstResult > 0) {
            query.setFirstResult(firstResult);
        }
        if (maxNumberOfResults > 0) {
            query.setMaxResults(maxNumberOfResults);
        }
        return query.getResultList();
    }

    @Override
    public Object getSingleResultForQuery(String queryString, ParameterSource source) {
        Query query = this.getQuery(queryString, source);
        return query.getSingleResult();
    }

    @Override
    @Nullable
    public Object merge(Object entity) {
        return this.merge(entity, 0, false);
    }

    @Override
    @Nullable
    public Object merge(Object entity, int flushSize, boolean clearOnFlush) {
        Assert.notNull((Object)entity, (String)"The object to merge must not be null.");
        return this.persistOrMerge(entity, true, flushSize, clearOnFlush);
    }

    @Override
    public void persist(Object entity) {
        this.persist(entity, 0, false);
    }

    @Override
    public void persist(Object entity, int flushSize, boolean clearOnFlush) {
        Assert.notNull((Object)entity, (String)"The object to persist must not be null.");
        this.persistOrMerge(entity, false, flushSize, clearOnFlush);
    }

    @Nullable
    private Object persistOrMerge(Object entity, boolean isMerge, int flushSize, boolean clearOnFlush) {
        Object result = null;
        EntityManager entityManager = this.getEntityManager();
        if (entity instanceof Iterable) {
            result = this.persistOrMergeIterable(entity, isMerge, flushSize, clearOnFlush);
        } else if (isMerge) {
            result = entityManager.merge(entity);
        } else {
            entityManager.persist(entity);
        }
        if (flushSize > 0) {
            entityManager.flush();
            if (clearOnFlush) {
                entityManager.clear();
            }
        }
        return result;
    }

    @Nullable
    private Object persistOrMergeIterable(Object entity, boolean isMerge, int flushSize, boolean clearOnFlush) {
        ArrayList<Object> result = null;
        Iterable entities = (Iterable)entity;
        AtomicInteger savedEntities = new AtomicInteger();
        AtomicInteger nullEntities = new AtomicInteger();
        ArrayList<Object> mergedEntities = new ArrayList<Object>();
        EntityManager entityManager = this.getEntityManager();
        for (Object iteratedEntity : entities) {
            if (iteratedEntity == null) {
                nullEntities.incrementAndGet();
                continue;
            }
            if (isMerge) {
                mergedEntities.add(entityManager.merge(iteratedEntity));
            } else {
                entityManager.persist(iteratedEntity);
            }
            savedEntities.incrementAndGet();
            if (flushSize <= 0 || savedEntities.get() % flushSize != 0) continue;
            entityManager.flush();
            if (!clearOnFlush) continue;
            entityManager.clear();
        }
        LOGGER.debug(() -> String.format("%s %s entities. %s NULL entities were ignored.", isMerge ? "Merged" : "Persisted", savedEntities.get(), nullEntities));
        if (isMerge) {
            result = mergedEntities;
        }
        return result;
    }

    private void setParametersIfRequired(String queryString, @Nullable ParameterSource source, Query query) {
        Set parameters = query.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            if (source != null) {
                for (Parameter param : parameters) {
                    Object paramValue;
                    String paramName = param.getName();
                    Integer position = param.getPosition();
                    if (position != null) {
                        if (source instanceof PositionSupportingParameterSource) {
                            paramValue = ((PositionSupportingParameterSource)source).getValueByPosition(position);
                            query.setParameter(position.intValue(), paramValue);
                            continue;
                        }
                        throw new JpaOperationFailedException("Positional Parameters are only support for PositionSupportingParameterSources.", queryString);
                    }
                    if (StringUtils.hasText((String)paramName)) {
                        paramValue = source.getValue(paramName);
                        query.setParameter(paramName, paramValue);
                        continue;
                    }
                    throw new JpaOperationFailedException("This parameter does not contain a parameter name. Additionally it is not a positional parameter, neither.", queryString);
                }
            } else {
                throw new IllegalArgumentException("Query has parameters but no parameter source provided");
            }
        }
    }
}

