/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rmi;

import java.rmi.RemoteException;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.remoting.rmi.RmiServiceExporter;
import org.springframework.remoting.support.RemoteInvocationExecutor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Deprecated
public class RmiInboundGateway
extends MessagingGatewaySupport
implements RequestReplyExchanger {
    public static final String SERVICE_NAME_PREFIX = "org.springframework.integration.rmiGateway.";
    private final RmiServiceExporter exporter = new RmiServiceExporter();
    private String requestChannelName;
    private String registryHost;
    private int registryPort = 1099;
    private boolean expectReply = true;
    private RemoteInvocationExecutor remoteInvocationExecutor;

    public void setRequestChannel(MessageChannel requestChannel) {
        Assert.notNull((Object)requestChannel, (String)"requestChannel must not be null");
        Assert.isTrue((requestChannel instanceof NamedComponent && StringUtils.hasText((String)((NamedComponent)requestChannel).getComponentName()) ? 1 : 0) != 0, (String)"RmiGateway's request channel must have a name.");
        this.requestChannelName = ((NamedComponent)requestChannel).getComponentName();
        super.setRequestChannel(requestChannel);
    }

    public void setRequestChannelName(String requestChannelName) {
        this.requestChannelName = requestChannelName;
        super.setRequestChannelName(requestChannelName);
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public void setRemoteInvocationExecutor(RemoteInvocationExecutor remoteInvocationExecutor) {
        this.remoteInvocationExecutor = remoteInvocationExecutor;
    }

    public String getComponentType() {
        return "rmi:inbound-gateway";
    }

    protected void onInit() {
        super.onInit();
        if (this.registryHost != null) {
            this.exporter.setRegistryHost(this.registryHost);
        }
        this.exporter.setRegistryPort(this.registryPort);
        if (this.remoteInvocationExecutor != null) {
            this.exporter.setRemoteInvocationExecutor(this.remoteInvocationExecutor);
        }
        this.exporter.setService((Object)this);
        this.exporter.setServiceInterface(RequestReplyExchanger.class);
        this.exporter.setServiceName(SERVICE_NAME_PREFIX + this.requestChannelName);
        try {
            this.exporter.afterPropertiesSet();
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public Message<?> exchange(Message<?> message) {
        if (this.expectReply) {
            return this.sendAndReceiveMessage(message);
        }
        this.send(message);
        return null;
    }

    public void destroy() {
        try {
            super.destroy();
            this.exporter.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

