/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.gateway;

import com.jcraft.jsch.ChannelSftp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.gateway.AbstractRemoteFileOutboundGateway;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.sftp.session.SftpFileInfo;

public class SftpOutboundGateway
extends AbstractRemoteFileOutboundGateway<ChannelSftp.LsEntry> {
    public SftpOutboundGateway(SessionFactory<ChannelSftp.LsEntry> sessionFactory, String command, String expression) {
        super(sessionFactory, command, expression);
    }

    public SftpOutboundGateway(RemoteFileTemplate<ChannelSftp.LsEntry> remoteFileTemplate, String command, String expression) {
        super(remoteFileTemplate, command, expression);
    }

    protected boolean isDirectory(ChannelSftp.LsEntry file) {
        return file.getAttrs().isDir();
    }

    protected boolean isLink(ChannelSftp.LsEntry file) {
        return file.getAttrs().isLink();
    }

    protected String getFilename(ChannelSftp.LsEntry file) {
        return file.getFilename();
    }

    protected String getFilename(AbstractFileInfo<ChannelSftp.LsEntry> file) {
        return file.getFilename();
    }

    protected List<AbstractFileInfo<ChannelSftp.LsEntry>> asFileInfoList(Collection<ChannelSftp.LsEntry> files) {
        ArrayList<AbstractFileInfo<ChannelSftp.LsEntry>> canonicalFiles = new ArrayList<AbstractFileInfo<ChannelSftp.LsEntry>>();
        for (ChannelSftp.LsEntry file : files) {
            canonicalFiles.add(new SftpFileInfo(file));
        }
        return canonicalFiles;
    }

    protected long getModified(ChannelSftp.LsEntry file) {
        return (long)file.getAttrs().getMTime() * 1000L;
    }

    protected ChannelSftp.LsEntry enhanceNameWithSubDirectory(ChannelSftp.LsEntry file, String directory) {
        DirectFieldAccessor accessor = new DirectFieldAccessor((Object)file);
        accessor.setPropertyValue("filename", (Object)(directory + file.getFilename()));
        return file;
    }

    public String getComponentType() {
        return "sftp:outbound-gateway";
    }
}

