/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;

public final class MapContentMatchers<T, V>
extends TypeSafeMatcher<Map<? super T, ? super V>> {
    private final T key;
    private final Matcher<V> valueMatcher;

    private MapContentMatchers(T key, V value) {
        this(key, Matchers.equalTo(value));
    }

    private MapContentMatchers(T key, Matcher<V> valueMatcher) {
        this.key = key;
        this.valueMatcher = valueMatcher;
    }

    public boolean matchesSafely(Map<? super T, ? super V> item) {
        return item.containsKey(this.key) && this.valueMatcher.matches(item.get(this.key));
    }

    public void describeTo(Description description) {
        description.appendText("an entry with key ").appendValue(this.key).appendText(" and value matching ").appendDescriptionOf(this.valueMatcher);
    }

    public static <T, V> Matcher<Map<T, V>> hasAllEntries(Map<T, V> entries) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>(entries.size());
        for (Map.Entry<T, V> entry : entries.entrySet()) {
            V value = entry.getValue();
            if (value instanceof Matcher) {
                matchers.add(Matchers.hasEntry((Matcher)Matchers.is(entry.getKey()), (Matcher)((Matcher)value)));
                continue;
            }
            matchers.add(Matchers.hasEntry(entry.getKey(), value));
        }
        return AllOf.allOf(matchers);
    }
}

