/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.twitter.inbound.DirectMessageReceivingMessageSource;
import org.springframework.integration.twitter.inbound.MentionsReceivingMessageSource;
import org.springframework.integration.twitter.inbound.SearchReceivingMessageSource;
import org.springframework.integration.twitter.inbound.TimelineReceivingMessageSource;
import org.w3c.dom.Element;

public class TwitterInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        Class<?> clazz = TwitterInboundChannelAdapterParser.determineClass(element, parserContext);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(clazz);
        builder.addConstructorArgReference(element.getAttribute("twitter-template"));
        builder.addConstructorArgValue((Object)element.getAttribute("id"));
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"query");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"page-size");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"metadata-store");
        return builder.getBeanDefinition();
    }

    private static Class<?> determineClass(Element element, ParserContext parserContext) {
        Class clazz = null;
        String elementName = element.getLocalName().trim();
        if ("inbound-channel-adapter".equals(elementName)) {
            clazz = TimelineReceivingMessageSource.class;
        } else if ("dm-inbound-channel-adapter".equals(elementName)) {
            clazz = DirectMessageReceivingMessageSource.class;
        } else if ("mentions-inbound-channel-adapter".equals(elementName)) {
            clazz = MentionsReceivingMessageSource.class;
        } else if ("search-inbound-channel-adapter".equals(elementName)) {
            clazz = SearchReceivingMessageSource.class;
        } else {
            parserContext.getReaderContext().error("element '" + elementName + "' is not supported by this parser.", (Object)element);
        }
        return clazz;
    }
}

