/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.springframework.messaging.Message;
import org.springframework.util.ClassUtils;

public final class KafkaUtils {
    public static final boolean MICROMETER_PRESENT = ClassUtils.isPresent((String)"io.micrometer.core.instrument.MeterRegistry", (ClassLoader)KafkaUtils.class.getClassLoader());
    private static ThreadLocal<String> groupIds = new ThreadLocal();

    public static boolean returnTypeMessageOrCollectionOf(Method method) {
        Type returnType = method.getGenericReturnType();
        if (returnType.equals(Message.class)) {
            return true;
        }
        if (returnType instanceof ParameterizedType) {
            ParameterizedType prt = (ParameterizedType)returnType;
            Type rawType = prt.getRawType();
            if (rawType.equals(Message.class)) {
                return true;
            }
            if (rawType.equals(Collection.class)) {
                Type collectionType = prt.getActualTypeArguments()[0];
                if (collectionType.equals(Message.class)) {
                    return true;
                }
                return collectionType instanceof ParameterizedType && ((ParameterizedType)collectionType).getRawType().equals(Message.class);
            }
        }
        return false;
    }

    public static void setConsumerGroupId(String groupId) {
        groupIds.set(groupId);
    }

    public static String getConsumerGroupId() {
        return groupIds.get();
    }

    public static void clearConsumerGroupId() {
        groupIds.remove();
    }

    private KafkaUtils() {
    }
}

