/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.wrapper;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import org.springframework.modulith.aptk.tools.TypeMirrorWrapper;
import org.springframework.modulith.aptk.tools.wrapper.AnnotationValueWrapper;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeParameterElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.VariableElementWrapper;

public class ExecutableElementWrapper
extends ElementWrapper<ExecutableElement> {
    protected ExecutableElementWrapper(ExecutableElement executableElement) {
        super(executableElement);
    }

    public String getMethodSignature() {
        StringBuilder builder = new StringBuilder();
        if (!this.getTypeParameters().isEmpty()) {
            builder.append("<");
            builder.append(this.getTypeParameters().stream().map(tp -> tp.getSimpleName() + " extends " + tp.getBounds().stream().map(tm -> tm.getTypeDeclaration()).collect(Collectors.joining(" & "))).collect(Collectors.joining(", ")));
            builder.append("> ");
        }
        builder.append(this.getReturnType().getTypeDeclaration()).append(" ").append(this.getSimpleName());
        builder.append("(");
        if (this.isVarArgs()) {
            if (this.getParameters().size() > 1) {
                List<VariableElementWrapper> nonVarargParameters = this.getParameters().subList(0, this.getParameters().size() - 1);
                builder.append(nonVarargParameters.stream().map(element -> element.asType().getTypeDeclaration() + " " + element.getSimpleName()).collect(Collectors.joining(", ")));
                builder.append(", ");
            }
            VariableElementWrapper lastVariableElement = this.getParameters().get(this.getParameters().size() - 1);
            builder.append(lastVariableElement.asType().getWrappedComponentType().getTypeDeclaration()).append("... ").append(lastVariableElement.getSimpleName());
        } else {
            builder.append(((ExecutableElement)this.element).getParameters().stream().map(element -> TypeMirrorWrapper.wrap(element.asType()).getTypeDeclaration() + " " + element.getSimpleName()).collect(Collectors.joining(", ")));
        }
        builder.append(")");
        if (!this.getThrownTypes().isEmpty()) {
            builder.append(" throws ");
            builder.append(this.getThrownTypes().stream().map(TypeMirrorWrapper::getSimpleName).collect(Collectors.joining(", ")));
        }
        return builder.toString();
    }

    public Set<String> getImports() {
        HashSet<String> imports = new HashSet<String>();
        imports.addAll(this.getTypeParameters().stream().flatMap(tp -> tp.getBounds().stream()).flatMap(tm -> tm.getImports().stream()).collect(Collectors.toList()));
        imports.addAll(this.getReturnType().getImports());
        for (VariableElementWrapper typeParameterElement : this.getParameters()) {
            imports.addAll(typeParameterElement.asType().getImports());
        }
        for (TypeMirrorWrapper thrownTypes : this.getThrownTypes()) {
            imports.addAll(thrownTypes.getImports());
        }
        return imports;
    }

    public List<TypeParameterElementWrapper> getTypeParameters() {
        return ((ExecutableElement)this.element).getTypeParameters().stream().map(TypeParameterElementWrapper::wrap).collect(Collectors.toList());
    }

    public TypeMirrorWrapper getReturnType() {
        return TypeMirrorWrapper.wrap(((ExecutableElement)this.element).getReturnType());
    }

    public List<VariableElementWrapper> getParameters() {
        return ((ExecutableElement)this.element).getParameters().stream().map(VariableElementWrapper::wrap).collect(Collectors.toList());
    }

    public TypeMirrorWrapper getReceiverType() {
        return TypeMirrorWrapper.wrap(((ExecutableElement)this.element).getReceiverType());
    }

    public boolean isVarArgs() {
        return ((ExecutableElement)this.element).isVarArgs();
    }

    public boolean isDefault() {
        return ((ExecutableElement)this.element).isDefault();
    }

    public List<TypeMirrorWrapper> getThrownTypes() {
        return ((ExecutableElement)this.element).getThrownTypes().stream().map(TypeMirrorWrapper::wrap).collect(Collectors.toList());
    }

    public Optional<AnnotationValueWrapper> getDefaultValue() {
        return ((ExecutableElement)this.element).getDefaultValue() != null ? Optional.of(AnnotationValueWrapper.wrap(((ExecutableElement)this.element).getDefaultValue())) : Optional.empty();
    }

    public static ExecutableElementWrapper wrap(ExecutableElement executableElement) {
        return new ExecutableElementWrapper(executableElement);
    }
}

