/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.springframework.core.JdkVersion;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.AbstractSynchronizedOsgiTests;
import org.springframework.osgi.test.internal.util.PropertiesUtil;
import org.springframework.osgi.test.provisioning.ArtifactLocator;
import org.springframework.osgi.test.provisioning.internal.LocalFileSystemMavenRepository;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractDependencyManagerTests
extends AbstractSynchronizedOsgiTests {
    private static final String TEST_FRRAMEWORK_BUNDLES_CONF_FILE = "/org/springframework/osgi/test/internal/boot-bundles.properties";
    private static final String IGNORE = "ignore";
    private ArtifactLocator locator = new LocalFileSystemMavenRepository();
    private static final String SPRING_OSGI_VERSION_PROP_KEY = "ignore.spring.osgi.version";
    private static final String SPRING_VERSION_PROP_KEY = "ignore.spring.version";
    private String springOsgiVersion = null;
    private String springBundledVersion = null;

    public AbstractDependencyManagerTests() {
    }

    public AbstractDependencyManagerTests(String name) {
        super(name);
    }

    protected String getSpringDMVersion() {
        if (this.springOsgiVersion == null) {
            this.springOsgiVersion = this.readProperty(SPRING_OSGI_VERSION_PROP_KEY);
        }
        return this.springOsgiVersion;
    }

    protected String getSpringVersion() {
        if (this.springBundledVersion == null) {
            this.springBundledVersion = this.readProperty(SPRING_VERSION_PROP_KEY);
        }
        return this.springBundledVersion;
    }

    private String readProperty(final String name) {
        if (System.getSecurityManager() != null) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(name);
                }
            });
        }
        return System.getProperty(name);
    }

    protected String[] getTestBundlesNames() {
        return new String[0];
    }

    protected String[] getTestFrameworkBundlesNames() {
        Properties props = PropertiesUtil.loadAndExpand(this.getTestingFrameworkBundlesConfiguration());
        if (props == null) {
            throw new IllegalArgumentException("cannot load default configuration from " + this.getTestingFrameworkBundlesConfiguration());
        }
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)("Loaded properties " + props));
        }
        System.getProperties().put(SPRING_OSGI_VERSION_PROP_KEY, props.get(SPRING_OSGI_VERSION_PROP_KEY));
        System.getProperties().put(SPRING_VERSION_PROP_KEY, props.get(SPRING_VERSION_PROP_KEY));
        Properties excluded = PropertiesUtil.filterKeysStartingWith(props, IGNORE);
        if (trace) {
            this.logger.trace((Object)("Excluded ignored properties " + excluded));
        }
        String sign = null;
        sign = JdkVersion.isAtLeastJava15() ? "-15" : "+15";
        excluded = PropertiesUtil.filterValuesStartingWith(props, sign);
        if (trace) {
            this.logger.trace((Object)("JDK " + JdkVersion.getJavaVersion() + " excluded bundles " + excluded));
        }
        Object[] bundles = props.keySet().toArray(new String[props.size()]);
        bundles = StringUtils.sortStringArray((String[])bundles);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Default framework bundles :" + ObjectUtils.nullSafeToString((Object[])bundles)));
        }
        return bundles;
    }

    protected Resource getTestingFrameworkBundlesConfiguration() {
        return new InputStreamResource(AbstractDependencyManagerTests.class.getResourceAsStream(TEST_FRRAMEWORK_BUNDLES_CONF_FILE));
    }

    protected Resource[] getTestBundles() {
        return this.locateBundles(this.getTestBundlesNames());
    }

    protected Resource[] getTestFrameworkBundles() {
        return this.locateBundles(this.getTestFrameworkBundlesNames());
    }

    protected Resource[] locateBundles(String[] bundles) {
        if (bundles == null) {
            bundles = new String[]{};
        }
        Resource[] res = new Resource[bundles.length];
        for (int i = 0; i < bundles.length; ++i) {
            res[i] = this.locateBundle(bundles[i]);
        }
        return res;
    }

    protected void preProcessBundleContext(BundleContext platformBundleContext) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.setProperty("log4j.ignoreTCL", "true");
                return null;
            }
        });
        super.preProcessBundleContext(platformBundleContext);
    }

    protected Resource locateBundle(String bundleId) {
        Assert.hasText((String)bundleId, (String)"bundleId should not be empty");
        String[] artifactId = StringUtils.commaDelimitedListToStringArray((String)bundleId);
        Assert.isTrue((artifactId.length >= 3 ? 1 : 0) != 0, (String)("the CSV string " + bundleId + " contains too few values"));
        for (int i = 0; i < artifactId.length; ++i) {
            artifactId[i] = StringUtils.trimWhitespace((String)artifactId[i]);
        }
        ArtifactLocator aLocator = this.getLocator();
        return artifactId.length == 3 ? aLocator.locateArtifact(artifactId[0], artifactId[1], artifactId[2]) : aLocator.locateArtifact(artifactId[0], artifactId[1], artifactId[2], artifactId[3]);
    }

    protected ArtifactLocator getLocator() {
        return this.locator;
    }
}

