/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.util.jar;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.osgi.test.internal.util.jar.JarUtils;
import org.springframework.osgi.test.internal.util.jar.storage.MemoryStorage;
import org.springframework.osgi.test.internal.util.jar.storage.Storage;
import org.springframework.util.StringUtils;

public class JarCreator {
    private static final Log log = LogFactory.getLog((Class)JarCreator.class);
    public static final String CLASS_PATTERN = "/**/*.class";
    public static final String XML_PATTERN = "/**/*.xml";
    public static final String PROPS_PATTERN = "/**/*.properties";
    public static final String EVERYTHING_PATTERN = "/**/*";
    private static final String[] LIMITED_PATTERN = new String[]{"/**/*.class", "/**/*.xml", "/**/*.properties"};
    private static final String CLASS_EXT = ".class";
    private static final String TEST_CLASSES_DIR = "test-classes";
    private String[] contentPattern = new String[]{"/**/*"};
    private ResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
    private Storage storage = new MemoryStorage();
    private String rootPath = this.determineRootPath();
    private boolean addFolders = true;
    private Collection containedPackages = new TreeSet();

    public String determineRootPath() {
        try {
            DefaultResourceLoader fileLoader = new DefaultResourceLoader();
            Resource res = fileLoader.getResource(this.getClass().getName().replace('.', '/').concat(CLASS_EXT));
            String fileLocation = "file://" + res.getFile().getAbsolutePath();
            fileLocation = fileLocation.substring(0, fileLocation.indexOf(TEST_CLASSES_DIR)) + TEST_CLASSES_DIR;
            if (res.exists()) {
                return fileLocation;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "file:./target/test-classes";
    }

    protected int addJarContent(Manifest manifest, Map entries) throws IOException {
        if (log.isTraceEnabled()) {
            if (manifest != null) {
                log.trace((Object)("Adding MANIFEST.MF [" + manifest.getMainAttributes().entrySet() + "]"));
            }
            log.trace((Object)"Adding entries:");
            Set key = entries.keySet();
            Iterator iter = key.iterator();
            while (iter.hasNext()) {
                log.trace(iter.next());
            }
        }
        return JarUtils.createJar(manifest, entries, this.storage.getOutputStream());
    }

    public Resource createJar(Manifest manifest) {
        return this.createJar(manifest, this.resolveContent());
    }

    public Resource createJar(Manifest manifest, Map content) {
        try {
            this.addJarContent(manifest, content);
            return this.storage.getResource();
        }
        catch (IOException ex) {
            throw (RuntimeException)new IllegalStateException("Cannot create jar").initCause(ex);
        }
    }

    private String determineRelativeName(String rootPath, Resource resource) {
        try {
            String path = StringUtils.cleanPath((String)resource.getURL().toExternalForm());
            return path.substring(path.indexOf(rootPath) + rootPath.length());
        }
        catch (IOException ex) {
            throw (RuntimeException)new IllegalArgumentException("illegal resource " + resource.toString()).initCause(ex);
        }
    }

    private Resource[][] resolveResources() {
        ResourcePatternResolver resolver = this.getPatternResolver();
        String[] patterns = this.getContentPattern();
        Resource[][] resources = new Resource[patterns.length][];
        for (int i = 0; i < patterns.length; ++i) {
            StringBuffer buffer = new StringBuffer(this.rootPath);
            if (!this.rootPath.endsWith("/") && !patterns[i].startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(patterns[i]);
            try {
                resources[i] = resolver.getResources(buffer.toString());
                continue;
            }
            catch (IOException ex) {
                IllegalStateException re = new IllegalStateException("cannot resolve pattern " + buffer.toString());
                re.initCause(ex);
                throw re;
            }
        }
        return resources;
    }

    public Map resolveContent() {
        URL rootURL;
        Resource[][] resources = this.resolveResources();
        String rootP = this.getRootPath();
        try {
            rootURL = new URL(rootP);
        }
        catch (MalformedURLException ex) {
            throw (RuntimeException)new IllegalArgumentException("illegal root path given " + rootP).initCause(ex);
        }
        String rootPath = StringUtils.cleanPath((String)rootURL.getPath());
        TreeMap<String, Object> entries = new TreeMap<String, Object>();
        this.containedPackages.clear();
        ByteArrayResource folderResource = new ByteArrayResource(new byte[0]);
        for (int i = 0; i < resources.length; ++i) {
            for (int j = 0; j < resources[i].length; ++j) {
                int slashIndex;
                String relativeName = this.determineRelativeName(rootPath, resources[i][j]);
                if (!relativeName.startsWith("/")) {
                    relativeName = "/" + relativeName;
                }
                entries.put(relativeName, resources[i][j]);
                if (relativeName.endsWith(CLASS_EXT)) {
                    String clazzName = relativeName.substring(1, relativeName.length() - CLASS_EXT.length()).replace('/', '.');
                    int index = clazzName.lastIndexOf(46);
                    if (index > 0) {
                        clazzName = clazzName.substring(0, index);
                    }
                    this.containedPackages.add(clazzName);
                }
                String token = relativeName;
                if (!this.addFolders) continue;
                entries.put("/META-INF/", folderResource);
                while ((slashIndex = token.lastIndexOf(47)) > 1) {
                    entries.put(token.substring(0, slashIndex + 1), folderResource);
                    token = token.substring(0, slashIndex);
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("The following packages were discovered in the bundle: " + this.containedPackages));
        }
        return entries;
    }

    public Collection getContainedPackages() {
        return this.containedPackages;
    }

    public String[] getContentPattern() {
        return this.contentPattern;
    }

    public void setContentPattern(String[] contentPattern) {
        this.contentPattern = contentPattern;
    }

    public ResourcePatternResolver getPatternResolver() {
        return this.patternResolver;
    }

    public void setPatternResolver(ResourcePatternResolver patternResolver) {
        this.patternResolver = patternResolver;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage jarStorage) {
        this.storage = jarStorage;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public boolean isAddFolders() {
        return this.addFolders;
    }

    public void setAddFolders(boolean addFolders) {
        this.addFolders = addFolders;
    }
}

