/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.web.deployer.jetty;

import javax.servlet.ServletContext;
import org.mortbay.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.springframework.osgi.web.deployer.OsgiWarDeploymentException;
import org.springframework.osgi.web.deployer.WarDeployment;
import org.springframework.osgi.web.deployer.WarDeploymentContext;
import org.springframework.osgi.web.deployer.internal.support.DefaultWarDeploymentContext;
import org.springframework.osgi.web.deployer.jetty.JettyContextUndeployer;

class JettyWarDeployment
implements WarDeployment {
    private boolean active = true;
    private final WebAppContext webAppCtx;
    private final JettyContextUndeployer undeployer;
    private final WarDeploymentContext deploymentContext;

    public JettyWarDeployment(JettyContextUndeployer jettyWarUndeployer, Bundle bundle, WebAppContext wac) {
        this.undeployer = jettyWarUndeployer;
        this.webAppCtx = wac;
        this.deploymentContext = new DefaultWarDeploymentContext(bundle, wac.getContextPath(), (ServletContext)wac.getServletContext());
    }

    public WarDeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    public boolean isActive() {
        return this.active;
    }

    public void undeploy() throws OsgiWarDeploymentException {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.undeployer.undeploy(this.webAppCtx);
    }

    WebAppContext getWebAppContext() {
        return this.webAppCtx;
    }
}

