/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.web;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.web.authentication.OidcLogoutAuthenticationConverter;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public final class OidcLogoutEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OIDC_LOGOUT_ENDPOINT_URI = "/connect/logout";
    private final AuthenticationManager authenticationManager;
    private final RequestMatcher logoutEndpointMatcher;
    private final LogoutHandler logoutHandler;
    private final LogoutSuccessHandler logoutSuccessHandler;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private AuthenticationConverter authenticationConverter;
    private AuthenticationSuccessHandler authenticationSuccessHandler = this::performLogout;
    private AuthenticationFailureHandler authenticationFailureHandler = this::sendErrorResponse;

    public OidcLogoutEndpointFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_OIDC_LOGOUT_ENDPOINT_URI);
    }

    public OidcLogoutEndpointFilter(AuthenticationManager authenticationManager, String logoutEndpointUri) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.hasText((String)logoutEndpointUri, (String)"logoutEndpointUri cannot be empty");
        this.authenticationManager = authenticationManager;
        this.logoutEndpointMatcher = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(logoutEndpointUri, HttpMethod.GET.name()), new AntPathRequestMatcher(logoutEndpointUri, HttpMethod.POST.name())});
        this.logoutHandler = new SecurityContextLogoutHandler();
        SimpleUrlLogoutSuccessHandler urlLogoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        urlLogoutSuccessHandler.setDefaultTargetUrl("/");
        this.logoutSuccessHandler = urlLogoutSuccessHandler;
        this.authenticationConverter = new OidcLogoutAuthenticationConverter();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.logoutEndpointMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            Authentication oidcLogoutAuthentication = this.authenticationConverter.convert(request);
            Authentication oidcLogoutAuthenticationResult = this.authenticationManager.authenticate(oidcLogoutAuthentication);
            this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, oidcLogoutAuthenticationResult);
        }
        catch (OAuth2AuthenticationException ex) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Logout request failed: %s", (Object)ex.getError()), (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)ex);
        }
        catch (Exception ex) {
            OAuth2Error error = new OAuth2Error("invalid_request", "OpenID Connect 1.0 RP-Initiated Logout Error: " + ex.getMessage(), "https://openid.net/specs/openid-connect-rpinitiated-1_0.html#ValidationAndErrorHandling");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)error, (Throwable)ex);
            }
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)new OAuth2AuthenticationException(error));
        }
    }

    public void setAuthenticationConverter(AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationConverter = authenticationConverter;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    private void performLogout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        OidcLogoutAuthenticationToken oidcLogoutAuthentication = (OidcLogoutAuthenticationToken)authentication;
        if (oidcLogoutAuthentication.isPrincipalAuthenticated() && StringUtils.hasText((String)oidcLogoutAuthentication.getSessionId())) {
            this.logoutHandler.logout(request, response, (Authentication)oidcLogoutAuthentication.getPrincipal());
        }
        if (oidcLogoutAuthentication.isAuthenticated() && StringUtils.hasText((String)oidcLogoutAuthentication.getPostLogoutRedirectUri())) {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)oidcLogoutAuthentication.getPostLogoutRedirectUri());
            if (StringUtils.hasText((String)oidcLogoutAuthentication.getState())) {
                uriBuilder.queryParam("state", new Object[]{UriUtils.encode((String)oidcLogoutAuthentication.getState(), (Charset)StandardCharsets.UTF_8)});
            }
            String redirectUri = uriBuilder.build(true).toUriString();
            this.redirectStrategy.sendRedirect(request, response, redirectUri);
        } else {
            this.logoutSuccessHandler.onLogoutSuccess(request, response, (Authentication)oidcLogoutAuthentication.getPrincipal());
        }
    }

    private void sendErrorResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException {
        OAuth2Error error = ((OAuth2AuthenticationException)exception).getError();
        response.sendError(HttpStatus.BAD_REQUEST.value(), error.toString());
    }
}

