/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Arrays;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.provider.service.registration.OpenSamlRelyingPartyRegistrationBuilderHttpMessageConverter;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public final class RelyingPartyRegistrations {
    private static final RestOperations rest = new RestTemplate(Arrays.asList(new OpenSamlRelyingPartyRegistrationBuilderHttpMessageConverter()));

    private RelyingPartyRegistrations() {
    }

    public static RelyingPartyRegistration.Builder fromMetadataLocation(String metadataLocation) {
        try {
            return (RelyingPartyRegistration.Builder)rest.getForObject(metadataLocation, RelyingPartyRegistration.Builder.class, new Object[0]);
        }
        catch (RestClientException ex) {
            if (ex.getCause() instanceof Saml2Exception) {
                throw (Saml2Exception)ex.getCause();
            }
            throw new Saml2Exception(ex);
        }
    }
}

