/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.servlet.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlAuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestContext;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationRequestFactory;
import org.springframework.security.saml2.provider.service.authentication.Saml2PostAuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.Saml2RedirectAuthenticationRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.Saml2MessageBinding;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.DefaultSaml2AuthenticationRequestContextResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestContextResolver;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class Saml2WebSsoAuthenticationRequestFilter
extends OncePerRequestFilter {
    private final Saml2AuthenticationRequestContextResolver authenticationRequestContextResolver;
    private Saml2AuthenticationRequestFactory authenticationRequestFactory;
    private RequestMatcher redirectMatcher = new AntPathRequestMatcher("/saml2/authenticate/{registrationId}");

    @Deprecated
    public Saml2WebSsoAuthenticationRequestFilter(RelyingPartyRegistrationRepository relyingPartyRegistrationRepository) {
        this(new DefaultSaml2AuthenticationRequestContextResolver(new DefaultRelyingPartyRegistrationResolver(relyingPartyRegistrationRepository)), new OpenSamlAuthenticationRequestFactory());
    }

    public Saml2WebSsoAuthenticationRequestFilter(Saml2AuthenticationRequestContextResolver authenticationRequestContextResolver, Saml2AuthenticationRequestFactory authenticationRequestFactory) {
        Assert.notNull((Object)authenticationRequestContextResolver, (String)"authenticationRequestContextResolver cannot be null");
        Assert.notNull((Object)authenticationRequestFactory, (String)"authenticationRequestFactory cannot be null");
        this.authenticationRequestContextResolver = authenticationRequestContextResolver;
        this.authenticationRequestFactory = authenticationRequestFactory;
    }

    @Deprecated
    public void setAuthenticationRequestFactory(Saml2AuthenticationRequestFactory authenticationRequestFactory) {
        Assert.notNull((Object)authenticationRequestFactory, (String)"authenticationRequestFactory cannot be null");
        this.authenticationRequestFactory = authenticationRequestFactory;
    }

    public void setRedirectMatcher(RequestMatcher redirectMatcher) {
        Assert.notNull((Object)redirectMatcher, (String)"redirectMatcher cannot be null");
        this.redirectMatcher = redirectMatcher;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        RequestMatcher.MatchResult matcher = this.redirectMatcher.matcher(request);
        if (!matcher.isMatch()) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Saml2AuthenticationRequestContext context = this.authenticationRequestContextResolver.resolve(request);
        if (context == null) {
            response.sendError(401);
            return;
        }
        RelyingPartyRegistration relyingParty = context.getRelyingPartyRegistration();
        if (relyingParty.getAssertingPartyDetails().getSingleSignOnServiceBinding() == Saml2MessageBinding.REDIRECT) {
            this.sendRedirect(response, context);
        } else {
            this.sendPost(response, context);
        }
    }

    private void sendRedirect(HttpServletResponse response, Saml2AuthenticationRequestContext context) throws IOException {
        Saml2RedirectAuthenticationRequest authenticationRequest = this.authenticationRequestFactory.createRedirectAuthenticationRequest(context);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authenticationRequest.getAuthenticationRequestUri());
        this.addParameter("SAMLRequest", authenticationRequest.getSamlRequest(), uriBuilder);
        this.addParameter("RelayState", authenticationRequest.getRelayState(), uriBuilder);
        this.addParameter("SigAlg", authenticationRequest.getSigAlg(), uriBuilder);
        this.addParameter("Signature", authenticationRequest.getSignature(), uriBuilder);
        String redirectUrl = uriBuilder.build(true).toUriString();
        response.sendRedirect(redirectUrl);
    }

    private void addParameter(String name, String value, UriComponentsBuilder builder) {
        Assert.hasText((String)name, (String)"name cannot be empty or null");
        if (StringUtils.hasText((String)value)) {
            builder.queryParam(UriUtils.encode((String)name, (Charset)StandardCharsets.ISO_8859_1), new Object[]{UriUtils.encode((String)value, (Charset)StandardCharsets.ISO_8859_1)});
        }
    }

    private void sendPost(HttpServletResponse response, Saml2AuthenticationRequestContext context) throws IOException {
        Saml2PostAuthenticationRequest authenticationRequest = this.authenticationRequestFactory.createPostAuthenticationRequest(context);
        String html = this.createSamlPostRequestFormData(authenticationRequest);
        response.setContentType("text/html");
        response.getWriter().write(html);
    }

    private String createSamlPostRequestFormData(Saml2PostAuthenticationRequest authenticationRequest) {
        String authenticationRequestUri = authenticationRequest.getAuthenticationRequestUri();
        String relayState = authenticationRequest.getRelayState();
        String samlRequest = authenticationRequest.getSamlRequest();
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE html>\n");
        html.append("<html>\n").append("    <head>\n");
        html.append("        <meta charset=\"utf-8\" />\n");
        html.append("    </head>\n");
        html.append("    <body onload=\"document.forms[0].submit()\">\n");
        html.append("        <noscript>\n");
        html.append("            <p>\n");
        html.append("                <strong>Note:</strong> Since your browser does not support JavaScript,\n");
        html.append("                you must press the Continue button once to proceed.\n");
        html.append("            </p>\n");
        html.append("        </noscript>\n");
        html.append("        \n");
        html.append("        <form action=\"");
        html.append(authenticationRequestUri);
        html.append("\" method=\"post\">\n");
        html.append("            <div>\n");
        html.append("                <input type=\"hidden\" name=\"SAMLRequest\" value=\"");
        html.append(HtmlUtils.htmlEscape((String)samlRequest));
        html.append("\"/>\n");
        if (StringUtils.hasText((String)relayState)) {
            html.append("                <input type=\"hidden\" name=\"RelayState\" value=\"");
            html.append(HtmlUtils.htmlEscape((String)relayState));
            html.append("\"/>\n");
        }
        html.append("            </div>\n");
        html.append("            <noscript>\n");
        html.append("                <div>\n");
        html.append("                    <input type=\"submit\" value=\"Continue\"/>\n");
        html.append("                </div>\n");
        html.append("            </noscript>\n");
        html.append("        </form>\n");
        html.append("        \n");
        html.append("    </body>\n");
        html.append("</html>");
        return html.toString();
    }
}

