/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server;

import java.util.Arrays;
import java.util.List;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.firewall.HttpStatusExchangeRejectedHandler;
import org.springframework.security.web.server.firewall.ServerExchangeRejectedException;
import org.springframework.security.web.server.firewall.ServerExchangeRejectedHandler;
import org.springframework.security.web.server.firewall.ServerWebExchangeFirewall;
import org.springframework.security.web.server.firewall.StrictServerWebExchangeFirewall;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.server.handler.DefaultWebFilterChain;
import org.springframework.web.server.handler.FilteringWebHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WebFilterChainProxy
implements WebFilter {
    private final List<SecurityWebFilterChain> filters;
    private ServerWebExchangeFirewall firewall = new StrictServerWebExchangeFirewall();
    private ServerExchangeRejectedHandler exchangeRejectedHandler = new HttpStatusExchangeRejectedHandler();

    public WebFilterChainProxy(List<SecurityWebFilterChain> filters) {
        this.filters = filters;
    }

    public WebFilterChainProxy(SecurityWebFilterChain ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.firewall.getFirewalledExchange(exchange).flatMap(firewalledExchange -> this.filterFirewalledExchange((ServerWebExchange)firewalledExchange, chain)).onErrorResume(ServerExchangeRejectedException.class, rejected -> this.exchangeRejectedHandler.handle(exchange, (ServerExchangeRejectedException)rejected).then(Mono.empty()));
    }

    private Mono<Void> filterFirewalledExchange(ServerWebExchange firewalledExchange, WebFilterChain chain) {
        return Flux.fromIterable(this.filters).filterWhen(securityWebFilterChain -> securityWebFilterChain.matches(firewalledExchange)).next().switchIfEmpty(chain.filter(firewalledExchange).then(Mono.empty())).flatMap(securityWebFilterChain -> securityWebFilterChain.getWebFilters().collectList()).map(filters -> new FilteringWebHandler(arg_0 -> ((WebFilterChain)chain).filter(arg_0), filters)).map(x$0 -> new DefaultWebFilterChain(x$0, new WebFilter[0])).flatMap(securedChain -> securedChain.filter(firewalledExchange));
    }

    public void setFirewall(ServerWebExchangeFirewall firewall) {
        Assert.notNull((Object)firewall, (String)"firewall cannot be null");
        this.firewall = firewall;
    }

    public void setExchangeRejectedHandler(ServerExchangeRejectedHandler exchangeRejectedHandler) {
        Assert.notNull((Object)exchangeRejectedHandler, (String)"exchangeRejectedHandler cannot be null");
        this.exchangeRejectedHandler = exchangeRejectedHandler;
    }
}

