/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.session;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;

public class RegisterSessionAuthenticationStrategy
implements SessionAuthenticationStrategy {
    private final SessionRegistry sessionRegistry;

    public RegisterSessionAuthenticationStrategy(SessionRegistry sessionRegistry) {
        Assert.notNull((Object)sessionRegistry, (String)"The sessionRegistry cannot be null");
        this.sessionRegistry = sessionRegistry;
    }

    @Override
    public void onAuthentication(Authentication authentication, HttpServletRequest request, HttpServletResponse response) {
        Object principal = authentication.getPrincipal();
        Assert.notNull((Object)principal, (String)"The principal cannot be null");
        this.sessionRegistry.registerNewSession(request.getSession().getId(), principal);
    }
}

