/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation;

import java.util.Properties;
import java.util.function.Predicate;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.session.data.redis.config.ConfigureReactiveRedisAction;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuples;

public class ConfigureNotifyKeyspaceEventsReactiveAction
implements ConfigureReactiveRedisAction {
    static final String CONFIG_NOTIFY_KEYSPACE_EVENTS = "notify-keyspace-events";

    @Override
    public Mono<Void> configure(ReactiveRedisConnection connection) {
        return this.getNotifyOptions(connection).map(notifyOptions -> {
            boolean A;
            Object customizedNotifyOptions = notifyOptions;
            if (!((String)customizedNotifyOptions).contains("E")) {
                customizedNotifyOptions = (String)customizedNotifyOptions + "E";
            }
            if (!(A = ((String)customizedNotifyOptions).contains("A")) && !((String)customizedNotifyOptions).contains("g")) {
                customizedNotifyOptions = (String)customizedNotifyOptions + "g";
            }
            if (!A && !((String)customizedNotifyOptions).contains("x")) {
                customizedNotifyOptions = (String)customizedNotifyOptions + "x";
            }
            return Tuples.of((Object)notifyOptions, (Object)customizedNotifyOptions);
        }).filter(optionsTuple -> !((String)optionsTuple.getT1()).equals(optionsTuple.getT2())).flatMap(optionsTuple -> connection.serverCommands().setConfig(CONFIG_NOTIFY_KEYSPACE_EVENTS, (String)optionsTuple.getT2())).filter("OK"::equals).doFinally(unused -> connection.close()).then();
    }

    private Mono<String> getNotifyOptions(ReactiveRedisConnection connection) {
        return connection.serverCommands().getConfig(CONFIG_NOTIFY_KEYSPACE_EVENTS).filter(Predicate.not(Properties::isEmpty)).map(config -> config.getProperty(config.stringPropertyNames().iterator().next())).onErrorMap(InvalidDataAccessApiUsageException.class, ex -> new IllegalStateException("Unable to configure Reactive Redis to keyspace notifications", (Throwable)ex));
    }
}

