/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.web;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.facebook.web.SignedRequestDecoder;
import org.springframework.social.facebook.web.SignedRequestException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
@RequestMapping(value={"/disconnect/facebook"})
public class DisconnectController {
    private static final Log logger = LogFactory.getLog(DisconnectController.class);
    private final SignedRequestDecoder signedRequestDecoder;
    private final UsersConnectionRepository usersConnectionRepository;

    public DisconnectController(UsersConnectionRepository usersConnectionRepository, String applicationSecret) {
        this.usersConnectionRepository = usersConnectionRepository;
        this.signedRequestDecoder = new SignedRequestDecoder(applicationSecret);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<String> disconnect(@RequestParam(value="signed_request") String signedRequest) {
        try {
            String userId = this.getUserId(signedRequest);
            logger.info((Object)("Deauthorization request received for Facebook User ID: " + userId + "; Removing connections."));
            HashSet<String> providerUserIds = new HashSet<String>();
            providerUserIds.add(userId);
            Set localUserIds = this.usersConnectionRepository.findUserIdsConnectedTo("facebook", providerUserIds);
            for (String localUserId : localUserIds) {
                ConnectionRepository connectionRepository = this.usersConnectionRepository.createConnectionRepository(localUserId);
                logger.info((Object)("  Removing Facebook connection for local user '" + localUserId + "'"));
                connectionRepository.removeConnection(new ConnectionKey("facebook", userId));
            }
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        catch (SignedRequestException e) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    private String getUserId(String signedRequest) throws SignedRequestException {
        return (String)this.signedRequestDecoder.decodeSignedRequest(signedRequest, Map.class).get("user_id");
    }
}

