/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.web;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.social.facebook.web.SignedRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedRequestDecoder {
    private String secret;
    private ObjectMapper objectMapper;
    private static final String PADDING = "===";
    private static final String HMAC_SHA256_MAC_NAME = "HMACSHA256";

    public SignedRequestDecoder(String secret) {
        this.secret = secret;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    public Map<String, ?> decodeSignedRequest(String signedRequest) throws SignedRequestException {
        return this.decodeSignedRequest(signedRequest, Map.class);
    }

    public <T> T decodeSignedRequest(String signedRequest, Class<T> type) throws SignedRequestException {
        String[] split = signedRequest.split("\\.");
        String encodedSignature = split[0];
        String payload = split[1];
        String decoded = this.base64DecodeToString(payload);
        byte[] signature = this.base64DecodeToBytes(encodedSignature);
        try {
            Object data = this.objectMapper.readValue(decoded, type);
            String algorithm = this.objectMapper.readTree(decoded).get("algorithm").textValue();
            if (algorithm == null || !algorithm.equals("HMAC-SHA256")) {
                throw new SignedRequestException("Unknown encryption algorithm: " + algorithm);
            }
            byte[] expectedSignature = this.encrypt(payload, this.secret);
            if (!Arrays.equals(expectedSignature, signature)) {
                throw new SignedRequestException("Invalid signature.");
            }
            return (T)data;
        }
        catch (IOException e) {
            throw new SignedRequestException("Error parsing payload.", e);
        }
    }

    private String padForBase64(String base64) {
        return base64 + PADDING.substring(0, (4 - base64.length() % 4) % 4);
    }

    private byte[] base64DecodeToBytes(String in) {
        return Base64.decode((byte[])this.padForBase64(in.replace('_', '/').replace('-', '+')).getBytes());
    }

    private String base64DecodeToString(String in) {
        return new String(this.base64DecodeToBytes(in));
    }

    private byte[] encrypt(String base, String key) {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), HMAC_SHA256_MAC_NAME);
            Mac mac = Mac.getInstance(HMAC_SHA256_MAC_NAME);
            mac.init(secretKeySpec);
            return mac.doFinal(base.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
    }
}

