/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.aot;

import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.AotDetector;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.aot.AotTestContextInitializersCodeGenerator;
import org.springframework.test.context.aot.GeneratedMapUtils;

final class AotTestContextInitializersFactory {
    private static volatile @Nullable Map<String, Supplier<ApplicationContextInitializer<ConfigurableApplicationContext>>> contextInitializers;
    private static volatile @Nullable Map<String, Class<ApplicationContextInitializer<?>>> contextInitializerClasses;

    private AotTestContextInitializersFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, Supplier<ApplicationContextInitializer<ConfigurableApplicationContext>>> getContextInitializers() {
        Map<String, Supplier<ApplicationContextInitializer<ConfigurableApplicationContext>>> initializers = contextInitializers;
        if (initializers != null) return initializers;
        Class<AotTestContextInitializersFactory> clazz = AotTestContextInitializersFactory.class;
        synchronized (AotTestContextInitializersFactory.class) {
            initializers = contextInitializers;
            if (initializers != null) return initializers;
            contextInitializers = initializers = AotDetector.useGeneratedArtifacts() ? AotTestContextInitializersFactory.loadContextInitializersMap() : Map.of();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return initializers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, Class<ApplicationContextInitializer<?>>> getContextInitializerClasses() {
        Map<String, Class<ApplicationContextInitializer<?>>> initializerClasses = contextInitializerClasses;
        if (initializerClasses != null) return initializerClasses;
        Class<AotTestContextInitializersFactory> clazz = AotTestContextInitializersFactory.class;
        synchronized (AotTestContextInitializersFactory.class) {
            initializerClasses = contextInitializerClasses;
            if (initializerClasses != null) return initializerClasses;
            contextInitializerClasses = initializerClasses = AotDetector.useGeneratedArtifacts() ? AotTestContextInitializersFactory.loadContextInitializerClassesMap() : Map.of();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return initializerClasses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Class<AotTestContextInitializersFactory> clazz = AotTestContextInitializersFactory.class;
        synchronized (AotTestContextInitializersFactory.class) {
            contextInitializers = null;
            contextInitializerClasses = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static Map<String, Supplier<ApplicationContextInitializer<ConfigurableApplicationContext>>> loadContextInitializersMap() {
        String className = AotTestContextInitializersCodeGenerator.GENERATED_MAPPINGS_CLASS_NAME;
        String methodName = "getContextInitializers";
        return GeneratedMapUtils.loadMap(className, methodName);
    }

    private static Map<String, Class<ApplicationContextInitializer<?>>> loadContextInitializerClassesMap() {
        String className = AotTestContextInitializersCodeGenerator.GENERATED_MAPPINGS_CLASS_NAME;
        String methodName = "getContextInitializerClasses";
        return GeneratedMapUtils.loadMap(className, methodName);
    }
}

