/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.support.PropertySourceDescriptor;
import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.SimpleValueStyler;
import org.springframework.core.style.ToStringCreator;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.Assert;

class MergedTestPropertySources {
    private static final MergedTestPropertySources empty = new MergedTestPropertySources(List.of(), new String[0]);
    private final List<PropertySourceDescriptor> descriptors;
    private final String[] properties;

    static MergedTestPropertySources empty() {
        return empty;
    }

    MergedTestPropertySources(List<PropertySourceDescriptor> descriptors, String[] properties) {
        Assert.notNull(descriptors, (String)"The descriptors list must not be null");
        Assert.notNull((Object)properties, (String)"The properties array must not be null");
        this.descriptors = descriptors;
        this.properties = properties;
    }

    List<PropertySourceDescriptor> getPropertySourceDescriptors() {
        return this.descriptors;
    }

    String[] getProperties() {
        return this.properties;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        MergedTestPropertySources that = (MergedTestPropertySources)other;
        if (!this.descriptors.equals(that.descriptors)) {
            return false;
        }
        return Arrays.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = this.descriptors.hashCode();
        result = 31 * result + Arrays.hashCode(this.properties);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this, (ToStringStyler)new DefaultToStringStyler((ValueStyler)new SimpleValueStyler())).append("descriptors", this.descriptors).append("properties", (Object)this.properties).toString();
    }
}

