/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface NestedTestConfiguration {
    public static final String ENCLOSING_CONFIGURATION_PROPERTY_NAME = "spring.test.enclosing.configuration";

    public EnclosingConfiguration value();

    public static enum EnclosingConfiguration {
        INHERIT,
        OVERRIDE;


        public static @Nullable EnclosingConfiguration from(@Nullable String name) {
            if (name == null) {
                return null;
            }
            try {
                return EnclosingConfiguration.valueOf(name.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                Log logger = LogFactory.getLog(EnclosingConfiguration.class);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Failed to parse enclosing configuration mode from '%s': %s", name, ex.getMessage()));
                }
                return null;
            }
        }
    }
}

