/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.http;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractZonedDateTimeAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.data.TemporalOffset;
import org.springframework.http.HttpHeaders;

public class HttpHeadersAssert
extends AbstractObjectAssert<HttpHeadersAssert, HttpHeaders> {
    private final AbstractCollectionAssert<?, Collection<? extends String>, String, ObjectAssert<String>> namesAssert;

    public HttpHeadersAssert(HttpHeaders actual) {
        super((Object)actual, HttpHeadersAssert.class);
        this.as("HTTP headers", new Object[0]);
        this.namesAssert = (AbstractCollectionAssert)Assertions.assertThat((Collection)actual.headerNames()).as("HTTP header names", new Object[0]);
    }

    public HttpHeadersAssert containsHeader(String name) {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers contain HTTP header '%s'", new Object[]{name})).contains((Object[])new String[]{name});
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert containsHeaders(String ... names) {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers contain HTTP headers '%s'", new Object[]{Arrays.toString(names)})).contains((Object[])names);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert containsOnlyHeaders(String ... names) {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers contain only HTTP headers '%s'", new Object[]{Arrays.toString(names)})).containsOnly((Object[])names);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert doesNotContainHeader(String name) {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers do not contain HTTP header '%s'", new Object[]{name})).doesNotContain((Object[])new String[]{name});
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert doesNotContainHeaders(String ... names) {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers do not contain HTTP headers '%s'", new Object[]{Arrays.toString(names)})).doesNotContain((Object[])names);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasHeaderSatisfying(String name, Consumer<List<String>> valueRequirements) {
        this.containsHeader(name);
        ((ListAssert)Assertions.assertThat((List)((HttpHeaders)this.actual).get(name)).as("check all values for HTTP header '%s'", new Object[]{name})).satisfies(new ThrowingConsumer[]{values -> valueRequirements.accept((List<String>)values)});
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasValue(String name, String value) {
        this.containsHeader(name);
        ((AbstractStringAssert)Assertions.assertThat((String)((HttpHeaders)this.actual).getFirst(name)).as("check primary value for HTTP header '%s'", new Object[]{name})).isEqualTo(value);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasValue(String name, long value) {
        this.containsHeader(name);
        ((AbstractStringAssert)Assertions.assertThat((String)((HttpHeaders)this.actual).getFirst(name)).as("check primary long value for HTTP header '%s'", new Object[]{name})).asLong().isEqualTo(value);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasValue(String name, Instant value) {
        this.containsHeader(name);
        ((AbstractZonedDateTimeAssert)Assertions.assertThat((ZonedDateTime)((HttpHeaders)this.actual).getFirstZonedDateTime(name)).as("check primary date value for HTTP header '%s'", new Object[]{name})).isCloseTo(value.atZone(ZoneOffset.UTC), (TemporalOffset)Assertions.within((long)999L, (TemporalUnit)ChronoUnit.MILLIS));
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasSingleValue(String name, String value) {
        this.doesNotHaveSecondaryValues(name);
        return this.hasValue(name, value);
    }

    public HttpHeadersAssert hasSingleValue(String name, long value) {
        this.doesNotHaveSecondaryValues(name);
        return this.hasValue(name, value);
    }

    public HttpHeadersAssert hasSingleValue(String name, Instant value) {
        this.doesNotHaveSecondaryValues(name);
        return this.hasValue(name, value);
    }

    public HttpHeadersAssert hasExactlyValues(String name, List<String> values) {
        this.containsHeader(name);
        ((ListAssert)Assertions.assertThat((List)((HttpHeaders)this.actual).get(name)).as("check all values of HTTP header '%s'", new Object[]{name})).containsExactlyElementsOf(values);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasExactlyValuesInAnyOrder(String name, List<String> values) {
        this.containsHeader(name);
        ((ListAssert)Assertions.assertThat((List)((HttpHeaders)this.actual).get(name)).as("check all values of HTTP header '%s' in any order", new Object[]{name})).containsExactlyInAnyOrderElementsOf(values);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert isEmpty() {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers are empty", new Object[0])).isEmpty();
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert isNotEmpty() {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers are not empty", new Object[0])).isNotEmpty();
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasSize(int expected) {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers have size '%s'", new Object[]{expected})).hasSize(expected);
        return (HttpHeadersAssert)this.myself;
    }

    public HttpHeadersAssert hasSameSizeAs(HttpHeaders other) {
        ((AbstractCollectionAssert)this.namesAssert.as("check headers have same size as '%s'", new Object[]{other})).hasSize(other.size());
        return (HttpHeadersAssert)this.myself;
    }

    private HttpHeadersAssert doesNotHaveSecondaryValues(String name) {
        this.containsHeader(name);
        List values = ((HttpHeaders)this.actual).get(name);
        if (values != null && !values.isEmpty()) {
            int size = values.size();
            ((AbstractIntegerAssert)Assertions.assertThat((int)size).withFailMessage("Expected HTTP header '%s' to be present without secondary values, but found <%s> secondary value(s)", new Object[]{name, size - 1})).isOne();
        }
        return (HttpHeadersAssert)this.myself;
    }
}

