/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import jakarta.servlet.ServletContext;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.util.Assert;

public class ServletContextScope
implements Scope,
DisposableBean {
    private final ServletContext servletContext;
    private final Map<String, Runnable> destructionCallbacks = new LinkedHashMap<String, Runnable>();

    public ServletContextScope(ServletContext servletContext) {
        Assert.notNull((Object)servletContext, (String)"ServletContext must not be null");
        this.servletContext = servletContext;
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        Object scopedObject = this.servletContext.getAttribute(name);
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            this.servletContext.setAttribute(name, scopedObject);
        }
        return scopedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Object remove(String name) {
        Object scopedObject = this.servletContext.getAttribute(name);
        if (scopedObject != null) {
            Map<String, Runnable> map = this.destructionCallbacks;
            synchronized (map) {
                this.destructionCallbacks.remove(name);
            }
            this.servletContext.removeAttribute(name);
            return scopedObject;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Map<String, Runnable> map = this.destructionCallbacks;
        synchronized (map) {
            this.destructionCallbacks.put(name, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<String, Runnable> map = this.destructionCallbacks;
        synchronized (map) {
            for (Runnable runnable : this.destructionCallbacks.values()) {
                runnable.run();
            }
            this.destructionCallbacks.clear();
        }
    }
}

