/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractJacksonView;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonView
extends AbstractJacksonView {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    private @Nullable String jsonPrefix;
    private @Nullable Set<String> modelKeys;
    private boolean extractValueFromSingleKeyModel = false;

    public JacksonJsonView() {
        super((MapperBuilder<?, ?>)JsonMapper.builder(), DEFAULT_CONTENT_TYPE);
    }

    public JacksonJsonView(ObjectMapper objectMapper) {
        super(objectMapper, DEFAULT_CONTENT_TYPE);
    }

    public void setJsonPrefix(String jsonPrefix) {
        this.jsonPrefix = jsonPrefix;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.jsonPrefix = prefixJson ? ")]}', " : null;
    }

    @Override
    public void setModelKey(String modelKey) {
        this.modelKeys = Collections.singleton(modelKey);
    }

    public void setModelKeys(@Nullable Set<String> modelKeys) {
        this.modelKeys = modelKeys;
    }

    public final @Nullable Set<String> getModelKeys() {
        return this.modelKeys;
    }

    public void setExtractValueFromSingleKeyModel(boolean extractValueFromSingleKeyModel) {
        this.extractValueFromSingleKeyModel = extractValueFromSingleKeyModel;
    }

    @Override
    protected Object filterModel(Map<String, Object> model, HttpServletRequest request) {
        HashMap result = CollectionUtils.newHashMap((int)model.size());
        Set<String> modelKeys = !CollectionUtils.isEmpty(this.modelKeys) ? this.modelKeys : model.keySet();
        model.forEach((clazz, value) -> {
            if (!(value instanceof BindingResult) && modelKeys.contains(clazz) && !clazz.equals(JSON_VIEW_HINT) && !clazz.equals(FILTER_PROVIDER_HINT)) {
                result.put(clazz, value);
            }
        });
        return this.extractValueFromSingleKeyModel && result.size() == 1 ? result.values().iterator().next() : result;
    }

    @Override
    protected void writePrefix(JsonGenerator generator, Object object) throws IOException {
        if (this.jsonPrefix != null) {
            generator.writeRaw(this.jsonPrefix);
        }
    }
}

