/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter.jetty;

import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketSession;
import org.springframework.web.socket.handler.ExceptionWebSocketHandlerDecorator;

public class JettyWebSocketHandlerAdapter
implements Session.Listener {
    private static final Log logger = LogFactory.getLog(JettyWebSocketHandlerAdapter.class);
    private final WebSocketHandler webSocketHandler;
    private final JettyWebSocketSession wsSession;
    @Nullable
    private Session nativeSession;

    public JettyWebSocketHandlerAdapter(WebSocketHandler webSocketHandler, JettyWebSocketSession wsSession) {
        Assert.notNull((Object)webSocketHandler, (String)"WebSocketHandler must not be null");
        Assert.notNull((Object)wsSession, (String)"WebSocketSession must not be null");
        this.webSocketHandler = webSocketHandler;
        this.wsSession = wsSession;
    }

    public void onWebSocketOpen(Session session) {
        try {
            this.nativeSession = session;
            this.wsSession.initializeNativeSession(session);
            this.webSocketHandler.afterConnectionEstablished(this.wsSession);
            this.nativeSession.demand();
        }
        catch (Exception ex) {
            this.tryCloseWithError(ex);
        }
    }

    public void onWebSocketText(String payload) {
        Assert.state((this.nativeSession != null ? 1 : 0) != 0, (String)"No native session available");
        TextMessage message = new TextMessage(payload);
        try {
            this.webSocketHandler.handleMessage(this.wsSession, message);
            this.nativeSession.demand();
        }
        catch (Exception ex) {
            this.tryCloseWithError(ex);
        }
    }

    public void onWebSocketBinary(ByteBuffer payload, Callback callback) {
        Assert.state((this.nativeSession != null ? 1 : 0) != 0, (String)"No native session available");
        BinaryMessage message = new BinaryMessage(BufferUtil.copy((ByteBuffer)payload), true);
        callback.succeed();
        try {
            this.webSocketHandler.handleMessage(this.wsSession, message);
            this.nativeSession.demand();
        }
        catch (Exception ex) {
            this.tryCloseWithError(ex);
        }
    }

    public void onWebSocketPong(ByteBuffer payload) {
        Assert.state((this.nativeSession != null ? 1 : 0) != 0, (String)"No native session available");
        PongMessage message = new PongMessage(BufferUtil.copy((ByteBuffer)payload));
        try {
            this.webSocketHandler.handleMessage(this.wsSession, message);
            this.nativeSession.demand();
        }
        catch (Exception ex) {
            this.tryCloseWithError(ex);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        block2: {
            CloseStatus closeStatus = new CloseStatus(statusCode, reason);
            try {
                this.webSocketHandler.afterConnectionClosed(this.wsSession, closeStatus);
            }
            catch (Exception ex) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn((Object)("Unhandled exception from afterConnectionClosed for " + String.valueOf(this)), (Throwable)ex);
            }
        }
    }

    public void onWebSocketError(Throwable cause) {
        block2: {
            try {
                this.webSocketHandler.handleTransportError(this.wsSession, cause);
            }
            catch (Exception ex) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn((Object)("Unhandled exception from handleTransportError for " + String.valueOf(this)), (Throwable)ex);
            }
        }
    }

    private void tryCloseWithError(Throwable t) {
        if (this.nativeSession != null) {
            if (this.nativeSession.isOpen()) {
                ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
            } else {
                this.nativeSession.disconnect();
            }
        }
    }
}

