/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.test.assertj;

import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.springframework.statemachine.StateContext;

public class StateContextAssert
extends AbstractAssert<StateContextAssert, StateContext<?, ?>> {
    public StateContextAssert(StateContext<?, ?> actual) {
        super(actual, StateContextAssert.class);
    }

    public StateContextAssert hasStage(StateContext.Stage stage) {
        this.isNotNull();
        if (!Objects.deepEquals(((StateContext)this.actual).getStage(), stage)) {
            this.failWithMessage("Expected context's stage to be <%s> but was <%s>", new Object[]{stage, ((StateContext)this.actual).getStage()});
        }
        return this;
    }

    public StateContextAssert hasEvent(Object event) {
        this.isNotNull();
        if (!Objects.deepEquals(((StateContext)this.actual).getEvent(), event)) {
            this.failWithMessage("Expected context's event to be <%s> but was <%s>", new Object[]{event, ((StateContext)this.actual).getEvent()});
        }
        return this;
    }

    public StateContextAssert hasSourceId(Object id) {
        this.isNotNull();
        if (((StateContext)this.actual).getSource() == null) {
            this.failWithMessage("Expected context's source to be not null", new Object[0]);
        }
        if (!Objects.deepEquals(((StateContext)this.actual).getSource().getId(), id)) {
            this.failWithMessage("Expected context's source id to be <%s> but was <%s>", new Object[]{id, ((StateContext)this.actual).getSource().getId()});
        }
        return this;
    }

    public StateContextAssert doesNotHaveSource() {
        this.isNotNull();
        if (((StateContext)this.actual).getSource() != null) {
            this.failWithMessage("Expected context's source to be null but was <%s>", new Object[]{((StateContext)this.actual).getSource()});
        }
        return this;
    }

    public StateContextAssert hasTargetId(Object id) {
        this.isNotNull();
        if (((StateContext)this.actual).getTarget() == null) {
            this.failWithMessage("Expected context's target to be not null", new Object[0]);
        }
        if (!Objects.deepEquals(((StateContext)this.actual).getTarget().getId(), id)) {
            this.failWithMessage("Expected context's target id to be <%s> but was <%s>", new Object[]{id, ((StateContext)this.actual).getTarget().getId()});
        }
        return this;
    }

    public StateContextAssert doesNotHaveTarget() {
        this.isNotNull();
        if (((StateContext)this.actual).getTarget() != null) {
            this.failWithMessage("Expected context's target to be null but was <%s>", new Object[]{((StateContext)this.actual).getTarget()});
        }
        return this;
    }
}

