/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.test.support;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;

public class LatchStateMachineListener<S, E>
extends StateMachineListenerAdapter<S, E> {
    private final Object lock = new Object();
    private volatile CountDownLatch stateChangedLatch = new CountDownLatch(1);
    private volatile CountDownLatch stateEnteredLatch = new CountDownLatch(1);
    private volatile CountDownLatch stateExitedLatch = new CountDownLatch(1);
    private volatile CountDownLatch eventNotAcceptedLatch = new CountDownLatch(1);
    private volatile CountDownLatch transitionLatch = new CountDownLatch(1);
    private volatile CountDownLatch transitionStartedLatch = new CountDownLatch(1);
    private volatile CountDownLatch transitionEndedLatch = new CountDownLatch(1);
    private volatile CountDownLatch stateMachineStartedLatch = new CountDownLatch(1);
    private volatile CountDownLatch stateMachineStoppedLatch = new CountDownLatch(1);
    private volatile CountDownLatch extendedStateChangedLatch = new CountDownLatch(1);
    private final List<StateChangedWrapper<S, E>> stateChanged = new ArrayList<StateChangedWrapper<S, E>>();
    private final List<State<S, E>> stateEntered = new ArrayList<State<S, E>>();
    private final List<State<S, E>> stateExited = new ArrayList<State<S, E>>();
    private final List<Message<E>> eventNotAccepted = new ArrayList<Message<E>>();
    private final List<Transition<S, E>> transition = new ArrayList<Transition<S, E>>();
    private final List<Transition<S, E>> transitionStarted = new ArrayList<Transition<S, E>>();
    private final List<Transition<S, E>> transitionEnded = new ArrayList<Transition<S, E>>();
    private final List<StateMachine<S, E>> stateMachineStarted = new ArrayList<StateMachine<S, E>>();
    private final List<StateMachine<S, E>> stateMachineStopped = new ArrayList<StateMachine<S, E>>();
    private final List<ExtendedStateChangedWrapper> extendedStateChanged = new ArrayList<ExtendedStateChangedWrapper>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(State<S, E> from, State<S, E> to) {
        Object object = this.lock;
        synchronized (object) {
            this.stateChanged.add(new StateChangedWrapper<S, E>(from, to));
            this.stateChangedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateEntered(State<S, E> state) {
        Object object = this.lock;
        synchronized (object) {
            this.stateEntered.add(state);
            this.stateEnteredLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateExited(State<S, E> state) {
        Object object = this.lock;
        synchronized (object) {
            this.stateExited.add(state);
            this.stateExitedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventNotAccepted(Message<E> event) {
        Object object = this.lock;
        synchronized (object) {
            this.eventNotAccepted.add(event);
            this.eventNotAcceptedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(Transition<S, E> transition) {
        Object object = this.lock;
        synchronized (object) {
            this.transition.add(transition);
            this.transitionLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionStarted(Transition<S, E> transition) {
        Object object = this.lock;
        synchronized (object) {
            this.transitionStarted.add(transition);
            this.transitionStartedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionEnded(Transition<S, E> transition) {
        Object object = this.lock;
        synchronized (object) {
            this.transitionEnded.add(transition);
            this.transitionEndedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateMachineStarted(StateMachine<S, E> stateMachine) {
        Object object = this.lock;
        synchronized (object) {
            this.stateMachineStarted.add(stateMachine);
            this.stateMachineStartedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateMachineStopped(StateMachine<S, E> stateMachine) {
        Object object = this.lock;
        synchronized (object) {
            this.stateMachineStopped.add(stateMachine);
            this.stateMachineStoppedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendedStateChanged(Object key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            this.extendedStateChanged.add(new ExtendedStateChangedWrapper(key, value));
            this.extendedStateChangedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int stateChangedCount, int stateEnteredCount, int stateExitedCount, int eventNotAcceptedCount, int transitionCount, int transitionStartedCount, int transitionEndedCount, int stateMachineStartedCount, int stateMachineStoppedCount, int extendedStateChangedCount) {
        Object object = this.lock;
        synchronized (object) {
            this.stateChangedLatch = new CountDownLatch(stateChangedCount);
            this.stateEnteredLatch = new CountDownLatch(stateEnteredCount);
            this.stateExitedLatch = new CountDownLatch(stateExitedCount);
            this.eventNotAcceptedLatch = new CountDownLatch(eventNotAcceptedCount);
            this.transitionLatch = new CountDownLatch(transitionCount);
            this.transitionStartedLatch = new CountDownLatch(transitionStartedCount);
            this.transitionEndedLatch = new CountDownLatch(transitionEndedCount);
            this.stateMachineStartedLatch = new CountDownLatch(stateMachineStartedCount);
            this.stateMachineStoppedLatch = new CountDownLatch(stateMachineStoppedCount);
            this.extendedStateChangedLatch = new CountDownLatch(extendedStateChangedCount);
            this.stateChanged.clear();
            this.stateEntered.clear();
            this.stateExited.clear();
            this.eventNotAccepted.clear();
            this.transition.clear();
            this.transitionStarted.clear();
            this.transitionEnded.clear();
            this.stateMachineStarted.clear();
            this.stateMachineStopped.clear();
            this.extendedStateChanged.clear();
        }
    }

    public CountDownLatch getStateChangedLatch() {
        return this.stateChangedLatch;
    }

    public CountDownLatch getStateEnteredLatch() {
        return this.stateEnteredLatch;
    }

    public CountDownLatch getStateExitedLatch() {
        return this.stateExitedLatch;
    }

    public CountDownLatch getEventNotAcceptedLatch() {
        return this.eventNotAcceptedLatch;
    }

    public CountDownLatch getTransitionLatch() {
        return this.transitionLatch;
    }

    public CountDownLatch getTransitionStartedLatch() {
        return this.transitionStartedLatch;
    }

    public CountDownLatch getTransitionEndedLatch() {
        return this.transitionEndedLatch;
    }

    public CountDownLatch getStateMachineStartedLatch() {
        return this.stateMachineStartedLatch;
    }

    public CountDownLatch getStateMachineStoppedLatch() {
        return this.stateMachineStoppedLatch;
    }

    public CountDownLatch getExtendedStateChangedLatch() {
        return this.extendedStateChangedLatch;
    }

    public List<StateChangedWrapper<S, E>> getStateChanged() {
        return this.stateChanged;
    }

    public List<State<S, E>> getStateEntered() {
        return this.stateEntered;
    }

    public List<State<S, E>> getStateExited() {
        return this.stateExited;
    }

    public List<Message<E>> getEventNotAccepted() {
        return this.eventNotAccepted;
    }

    public List<Transition<S, E>> getTransition() {
        return this.transition;
    }

    public List<Transition<S, E>> getTransitionStarted() {
        return this.transitionStarted;
    }

    public List<Transition<S, E>> getTransitionEnded() {
        return this.transitionEnded;
    }

    public List<StateMachine<S, E>> getStateMachineStarted() {
        return this.stateMachineStarted;
    }

    public List<StateMachine<S, E>> getStateMachineStopped() {
        return this.stateMachineStopped;
    }

    public List<ExtendedStateChangedWrapper> getExtendedStateChanged() {
        return this.extendedStateChanged;
    }

    public static class StateChangedWrapper<S, E> {
        final State<S, E> from;
        final State<S, E> to;

        public StateChangedWrapper(State<S, E> from, State<S, E> to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class ExtendedStateChangedWrapper {
        final Object key;
        final Object value;

        public ExtendedStateChangedWrapper(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

