/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.spel;

import java.util.List;
import java.util.Map;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.ValueCoercionException;
import org.springframework.binding.expression.spel.EvaluationContextFactory;
import org.springframework.binding.expression.spel.StandardEvaluationContextFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class SpringELExpression
implements Expression {
    private final org.springframework.expression.Expression expression;
    private final Class<?> expectedType;
    private final EvaluationContextFactory contextFactory;

    public SpringELExpression(org.springframework.expression.Expression expression, Map<String, Expression> expressionVars, Class<?> expectedType, ConversionService conversionService, List<PropertyAccessor> propertyAccessors) {
        this(expression, expectedType, new StandardEvaluationContextFactory(propertyAccessors, conversionService, expressionVars));
    }

    public SpringELExpression(org.springframework.expression.Expression expression, Class<?> expectedType, EvaluationContextFactory contextFactory) {
        Assert.notNull((Object)expression, (String)"The SpelExpression is required for evaluation");
        Assert.notNull((Object)contextFactory, (String)"The EvaluationContextFactory is required");
        this.expression = expression;
        this.expectedType = expectedType;
        this.contextFactory = contextFactory;
    }

    @Override
    public String getExpressionString() {
        return this.expression.getExpressionString();
    }

    @Override
    public Object getValue(Object rootObject) throws EvaluationException {
        try {
            EvaluationContext context = this.contextFactory.createContext(rootObject);
            if (context instanceof StandardEvaluationContext) {
                this.extendEvaluationContext((StandardEvaluationContext)context);
            }
            return this.expression.getValue(context, this.expectedType);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            if (e.getMessageCode().equals((Object)SpelMessage.TYPE_CONVERSION_ERROR)) {
                throw new ValueCoercionException(rootObject.getClass(), this.getExpressionString(), null, this.expectedType, e);
            }
            throw new EvaluationException(rootObject.getClass(), this.expression.getExpressionString(), "An ELException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + String.valueOf(rootObject.getClass()) + "]", e);
        }
    }

    @Override
    public Class<?> getValueType(Object rootObject) throws EvaluationException {
        try {
            EvaluationContext context = this.contextFactory.createContext(rootObject);
            if (context instanceof StandardEvaluationContext) {
                this.extendEvaluationContext((StandardEvaluationContext)context);
            }
            return this.expression.getValueType(context);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_READABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            throw new EvaluationException(rootObject.getClass(), this.getExpressionString(), "An ELException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + String.valueOf(rootObject.getClass()) + "]", e);
        }
    }

    @Override
    public void setValue(Object rootObject, Object value) throws EvaluationException {
        try {
            EvaluationContext context = this.contextFactory.createContext(rootObject);
            if (context instanceof StandardEvaluationContext) {
                this.extendEvaluationContext((StandardEvaluationContext)context);
            }
            this.expression.setValue(context, value);
        }
        catch (SpelEvaluationException e) {
            if (e.getMessageCode().equals((Object)SpelMessage.PROPERTY_OR_FIELD_NOT_WRITABLE)) {
                throw new PropertyNotFoundException(rootObject.getClass(), this.getExpressionString(), e);
            }
            if (e.getMessageCode().equals((Object)SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE)) {
                throw new ValueCoercionException(rootObject.getClass(), this.getExpressionString(), value, this.expectedType, e);
            }
            throw new EvaluationException(rootObject.getClass(), this.getExpressionString(), "An ELException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + String.valueOf(rootObject.getClass()) + "] to [" + String.valueOf(value) + "]", e);
        }
    }

    @Deprecated
    protected void extendEvaluationContext(StandardEvaluationContext context) {
    }

    public String toString() {
        return this.getExpressionString();
    }
}

