/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import jakarta.faces.context.FacesContext;
import org.springframework.faces.webflow.FlowFacesContext;
import org.springframework.faces.webflow.FlowLifecycle;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.RequestContext;

public class FlowFacesContextLifecycleListener
implements FlowExecutionListener {
    public static final String DEFAULT_FACES_CONTEXT = FlowFacesContextLifecycleListener.class.getName() + ".DEFAULT_FACES_CONTEXT";

    public void requestSubmitted(RequestContext context) {
        FacesContext facesContext = this.getRequestFacesContext(context);
        if (facesContext != null) {
            new FlowFacesContext(context, facesContext);
            return;
        }
        FlowFacesContext.newInstance(context, FlowLifecycle.newInstance());
    }

    public void requestProcessed(RequestContext context) {
        if (this.getRequestFacesContext(context) != null) {
            return;
        }
        FacesContext.getCurrentInstance().release();
    }

    private FacesContext getRequestFacesContext(RequestContext context) {
        return (FacesContext)context.getExternalContext().getRequestMap().get(DEFAULT_FACES_CONTEXT);
    }
}

