/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.test.GeneratedFlowExecutionKey;
import org.springframework.webflow.test.MockFlowSession;
import org.springframework.webflow.test.MockRequestContext;

public class MockRequestControlContext
extends MockRequestContext
implements RequestControlContext {
    public MockRequestControlContext() {
    }

    public MockRequestControlContext(Flow flow) {
        super(flow);
    }

    public MockRequestControlContext(FlowExecutionContext flowExecutionContext) {
        super(flowExecutionContext);
    }

    public void setCurrentState(State state) {
        this.getMockFlowExecutionContext().getMockActiveSession().setState(state);
    }

    public FlowExecutionKey assignFlowExecutionKey() {
        GeneratedFlowExecutionKey key = new GeneratedFlowExecutionKey();
        this.getMockFlowExecutionContext().setKey(key);
        return key;
    }

    public void viewRendering(View view) {
    }

    public void viewRendered(View view) {
    }

    public boolean handleEvent(Event event) {
        this.setCurrentEvent(event);
        return ((Flow)this.getActiveFlow()).handleEvent(this);
    }

    public boolean execute(Transition transition) {
        return transition.execute((TransitionableState)this.getCurrentState(), this);
    }

    public void removeAllFlowExecutionSnapshots() {
    }

    public void removeCurrentFlowExecutionSnapshot() {
    }

    public void updateCurrentFlowExecutionSnapshot() {
    }

    public void start(Flow flow, MutableAttributeMap input) throws IllegalStateException {
        MockFlowSession session = new MockFlowSession(flow, input);
        if (this.getFlowExecutionContext().isActive()) {
            session.setParent(this.getFlowExecutionContext().getActiveSession());
        }
        this.getMockFlowExecutionContext().setActiveSession(session);
        flow.start(this, input);
    }

    public void endActiveFlowSession(String outcome, MutableAttributeMap output) throws IllegalStateException {
        MockFlowSession endingSession = this.getMockFlowExecutionContext().getMockActiveSession();
        endingSession.getDefinitionInternal().end(this, outcome, output);
        this.getMockFlowExecutionContext().setActiveSession(endingSession.getParent());
        if (!this.getMockFlowExecutionContext().hasEnded()) {
            this.handleEvent(new Event(endingSession.getState(), outcome, output));
        }
    }

    public boolean getRedirectOnPause() {
        if (!this.getExternalContext().isResponseAllowed()) {
            return true;
        }
        Boolean redirectOnPause = this.getMockFlowExecutionContext().getAttributes().getBoolean("alwaysRedirectOnPause");
        return redirectOnPause != null ? redirectOnPause : false;
    }

    public boolean getRedirectInSameState() {
        if (!this.getExternalContext().isResponseAllowed()) {
            return true;
        }
        Boolean redirectInSameState = this.getMockFlowExecutionContext().getAttributes().getBoolean("redirectInSameState");
        if (redirectInSameState != null) {
            return redirectInSameState;
        }
        return this.getRedirectOnPause();
    }

    public boolean getEmbeddedMode() {
        return this.getMockFlowExecutionContext().getMockActiveSession().isEmbeddedMode();
    }

    public void setAlwaysRedirectOnPause(boolean alwaysRedirectOnPause) {
        this.getMockFlowExecutionContext().getAttributeMap().put("alwaysRedirectOnPause", alwaysRedirectOnPause);
    }

    public void setRedirectInSameState(boolean redirectInSameState) {
        this.getMockFlowExecutionContext().getAttributeMap().put("redirectInSameState", redirectInSameState);
    }

    public void setEmbeddedMode() {
        this.getMockFlowExecutionContext().getMockActiveSession().setEmbeddedMode();
    }
}

