/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.builder.model;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.validation.Validator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.builder.FlowArtifactFactory;
import org.springframework.webflow.engine.builder.FlowBuilderContext;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.validation.ValidationHintResolver;

class LocalFlowBuilderContext
implements FlowBuilderContext {
    private FlowBuilderContext parent;
    private ApplicationContext localFlowContext;

    public LocalFlowBuilderContext(FlowBuilderContext parent, GenericApplicationContext localFlowContext) {
        this.parent = parent;
        this.localFlowContext = localFlowContext;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.localFlowContext;
    }

    @Override
    public String getFlowId() {
        return this.parent.getFlowId();
    }

    @Override
    public AttributeMap<Object> getFlowAttributes() {
        return this.parent.getFlowAttributes();
    }

    @Override
    public FlowDefinitionLocator getFlowDefinitionLocator() {
        if (this.localFlowContext.containsLocalBean("flowRegistry")) {
            return (FlowDefinitionLocator)this.localFlowContext.getBean("flowRegistry", FlowDefinitionLocator.class);
        }
        return this.parent.getFlowDefinitionLocator();
    }

    @Override
    public FlowArtifactFactory getFlowArtifactFactory() {
        if (this.localFlowContext.containsLocalBean("flowArtifactFactory")) {
            return (FlowArtifactFactory)this.localFlowContext.getBean("flowArtifactFactory", FlowArtifactFactory.class);
        }
        return this.parent.getFlowArtifactFactory();
    }

    @Override
    public ConversionService getConversionService() {
        if (this.localFlowContext.containsLocalBean("conversionService")) {
            return (ConversionService)this.localFlowContext.getBean("conversionService", ConversionService.class);
        }
        return this.parent.getConversionService();
    }

    @Override
    public ViewFactoryCreator getViewFactoryCreator() {
        if (this.localFlowContext.containsLocalBean("viewFactoryCreator")) {
            return (ViewFactoryCreator)this.localFlowContext.getBean("viewFactoryCreator", ViewFactoryCreator.class);
        }
        return this.parent.getViewFactoryCreator();
    }

    @Override
    public ExpressionParser getExpressionParser() {
        if (this.localFlowContext.containsLocalBean("expressionParser")) {
            return (ExpressionParser)this.localFlowContext.getBean("expressionParser", ExpressionParser.class);
        }
        return this.parent.getExpressionParser();
    }

    @Override
    public Validator getValidator() {
        if (this.localFlowContext.containsLocalBean("validator")) {
            return (Validator)this.localFlowContext.getBean("validator", Validator.class);
        }
        return this.parent.getValidator();
    }

    @Override
    public ValidationHintResolver getValidationHintResolver() {
        if (this.localFlowContext.containsLocalBean("validationHintResolver")) {
            return (ValidationHintResolver)this.localFlowContext.getBean("validationHintResolver", ValidationHintResolver.class);
        }
        return this.parent.getValidationHintResolver();
    }
}

