/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model.builder;

import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.model.FlowModel;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilderException;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;

public class DefaultFlowModelHolder
implements FlowModelHolder {
    private FlowModel flowModel;
    private FlowModelBuilder flowModelBuilder;
    private boolean assembling;

    public DefaultFlowModelHolder(FlowModelBuilder flowModelBuilder) {
        Assert.notNull((Object)flowModelBuilder, (String)"The flow model builder is required");
        this.flowModelBuilder = flowModelBuilder;
    }

    @Override
    public synchronized FlowModel getFlowModel() {
        if (this.assembling) {
            return this.flowModelBuilder.getFlowModel();
        }
        if (this.flowModel == null) {
            this.assembleFlowModel();
        } else if (this.flowModelBuilder.hasFlowModelResourceChanged()) {
            this.assembleFlowModel();
        }
        return this.flowModel;
    }

    @Override
    public Resource getFlowModelResource() {
        return this.flowModelBuilder.getFlowModelResource();
    }

    @Override
    public boolean hasFlowModelChanged() {
        return this.flowModelBuilder.hasFlowModelResourceChanged();
    }

    @Override
    public synchronized void refresh() {
        this.assembleFlowModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assembleFlowModel() throws FlowModelBuilderException {
        try {
            this.assembling = true;
            this.flowModelBuilder.init();
            this.flowModelBuilder.build();
            this.flowModel = this.flowModelBuilder.getFlowModel();
        }
        finally {
            try {
                this.flowModelBuilder.dispose();
            }
            finally {
                this.assembling = false;
            }
        }
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("flowModelBuilder", (Object)this.flowModelBuilder).toString();
    }
}

