/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xml.xsd.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.sax.SaxUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;
import org.springframework.xml.xsd.XsdSchema;
import org.springframework.xml.xsd.XsdSchemaCollection;
import org.springframework.xml.xsd.commons.CommonsXsdSchema;
import org.springframework.xml.xsd.commons.CommonsXsdSchemaException;
import org.xml.sax.InputSource;

public class CommonsXsdSchemaCollection
implements XsdSchemaCollection,
InitializingBean,
ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(CommonsXsdSchemaCollection.class);
    private final XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
    private final List<XmlSchema> xmlSchemas = new ArrayList<XmlSchema>();
    private Resource[] xsdResources;
    private boolean inline = false;
    private URIResolver uriResolver = new ClasspathUriResolver();
    private ResourceLoader resourceLoader;

    public CommonsXsdSchemaCollection() {
    }

    public CommonsXsdSchemaCollection(Resource ... resources) {
        this.xsdResources = resources;
    }

    public void setXsds(Resource ... xsdResources) {
        this.xsdResources = xsdResources;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setUriResolver(URIResolver uriResolver) {
        Assert.notNull((Object)uriResolver, (String)"'uriResolver' must not be null");
        this.uriResolver = uriResolver;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws IOException {
        Assert.notEmpty((Object[])this.xsdResources, (String)"'xsds' must not be empty");
        this.schemaCollection.setSchemaResolver(this.uriResolver);
        HashSet<XmlSchema> processedIncludes = new HashSet<XmlSchema>();
        HashSet<XmlSchema> processedImports = new HashSet<XmlSchema>();
        for (Resource xsdResource : this.xsdResources) {
            Assert.isTrue((boolean)xsdResource.exists(), (String)(xsdResource + " does not exist"));
            try {
                XmlSchema xmlSchema = this.schemaCollection.read(SaxUtils.createInputSource(xsdResource));
                this.xmlSchemas.add(xmlSchema);
                if (!this.inline) continue;
                this.inlineIncludes(xmlSchema, processedIncludes, processedImports);
                this.findImports(xmlSchema, processedImports, processedIncludes);
            }
            catch (Exception ex) {
                throw new CommonsXsdSchemaException("Schema [" + xsdResource + "] could not be loaded", ex);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Loaded " + StringUtils.arrayToCommaDelimitedString((Object[])this.xsdResources)));
        }
    }

    @Override
    public XsdSchema[] getXsdSchemas() {
        XsdSchema[] result = new XsdSchema[this.xmlSchemas.size()];
        for (int i = 0; i < this.xmlSchemas.size(); ++i) {
            XmlSchema xmlSchema = this.xmlSchemas.get(i);
            result[i] = new CommonsXsdSchema(xmlSchema, this.schemaCollection);
        }
        return result;
    }

    @Override
    public XmlValidator createValidator() {
        try {
            Resource[] resources = new Resource[this.xmlSchemas.size()];
            for (int i = this.xmlSchemas.size() - 1; i >= 0; --i) {
                XmlSchema xmlSchema = this.xmlSchemas.get(i);
                String sourceUri = xmlSchema.getSourceURI();
                if (!StringUtils.hasLength((String)sourceUri)) continue;
                resources[i] = new UrlResource(sourceUri);
            }
            return XmlValidatorFactory.createValidator(resources, "http://www.w3.org/2001/XMLSchema");
        }
        catch (IOException ex) {
            throw new CommonsXsdSchemaException(ex.getMessage(), ex);
        }
    }

    private void inlineIncludes(XmlSchema schema, Set<XmlSchema> processedIncludes, Set<XmlSchema> processedImports) {
        processedIncludes.add(schema);
        List schemaItems = schema.getItems();
        for (int i = 0; i < schemaItems.size(); ++i) {
            XmlSchemaObject schemaObject = (XmlSchemaObject)schemaItems.get(i);
            if (!(schemaObject instanceof XmlSchemaInclude)) continue;
            XmlSchema includedSchema = ((XmlSchemaInclude)schemaObject).getSchema();
            if (!processedIncludes.contains(includedSchema)) {
                this.inlineIncludes(includedSchema, processedIncludes, processedImports);
                this.findImports(includedSchema, processedImports, processedIncludes);
                List includeItems = includedSchema.getItems();
                for (XmlSchemaObject includedItem : includeItems) {
                    schemaItems.add(includedItem);
                }
            }
            schemaItems.remove(i);
            --i;
        }
    }

    private void findImports(XmlSchema schema, Set<XmlSchema> processedImports, Set<XmlSchema> processedIncludes) {
        processedImports.add(schema);
        List externals = schema.getExternals();
        for (XmlSchemaExternal external : externals) {
            if (!(external instanceof XmlSchemaImport)) continue;
            XmlSchemaImport schemaImport = (XmlSchemaImport)external;
            XmlSchema importedSchema = schemaImport.getSchema();
            if (!"http://www.w3.org/XML/1998/namespace".equals(schemaImport.getNamespace()) && importedSchema != null && !processedImports.contains(importedSchema)) {
                this.inlineIncludes(importedSchema, processedIncludes, processedImports);
                this.findImports(importedSchema, processedImports, processedIncludes);
                this.xmlSchemas.add(importedSchema);
            }
            external.setSchemaLocation(null);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CommonsXsdSchemaCollection");
        builder.append('{');
        for (int i = 0; i < this.xmlSchemas.size(); ++i) {
            XmlSchema schema = this.xmlSchemas.get(i);
            builder.append(schema.getTargetNamespace());
            if (i >= this.xmlSchemas.size() - 1) continue;
            builder.append(',');
        }
        builder.append('}');
        return builder.toString();
    }

    private class ClasspathUriResolver
    extends DefaultURIResolver {
        private ClasspathUriResolver() {
        }

        public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
            if (CommonsXsdSchemaCollection.this.resourceLoader != null) {
                String classpathLocation;
                Resource resource = CommonsXsdSchemaCollection.this.resourceLoader.getResource(schemaLocation);
                if (resource.exists()) {
                    return this.createInputSource(resource);
                }
                if (StringUtils.hasLength((String)baseUri)) {
                    try {
                        UrlResource baseUriResource = new UrlResource(baseUri);
                        resource = baseUriResource.createRelative(schemaLocation);
                        if (resource.exists()) {
                            return this.createInputSource(resource);
                        }
                    }
                    catch (IOException baseUriResource) {
                        // empty catch block
                    }
                }
                if ((resource = CommonsXsdSchemaCollection.this.resourceLoader.getResource(classpathLocation = "classpath:/" + schemaLocation)).exists()) {
                    return this.createInputSource(resource);
                }
            }
            return super.resolveEntity(namespace, schemaLocation, baseUri);
        }

        private InputSource createInputSource(Resource resource) {
            try {
                return SaxUtils.createInputSource(resource);
            }
            catch (IOException ex) {
                throw new CommonsXsdSchemaException("Could not resolve location", ex);
            }
        }
    }
}

