/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.jdbc;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.JdbcDatabaseContainerProvider;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.ConnectionUrl;
import org.testcontainers.jdbc.ConnectionWrapper;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public class ContainerDatabaseDriver
implements Driver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerDatabaseDriver.class);
    private Driver delegate;
    private static final Map<String, Set<Connection>> containerConnections = new HashMap<String, Set<Connection>>();
    private static final Map<String, JdbcDatabaseContainer> jdbcUrlContainerCache = new HashMap<String, JdbcDatabaseContainer>();
    private static final Set<String> initializedContainers = new HashSet<String>();
    private static final String FILE_PATH_PREFIX = "file:";

    private static void load() {
        try {
            DriverManager.registerDriver(new ContainerDatabaseDriver());
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to register driver", (Throwable)e);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:tc:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ConnectionUrl connectionUrl = ConnectionUrl.newInstance(url);
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            String queryString = connectionUrl.getQueryString().orElse("");
            JdbcDatabaseContainer container = jdbcUrlContainerCache.get(connectionUrl.getUrl());
            if (container == null) {
                LOGGER.debug("Container not found in cache, creating new instance");
                Map<String, String> parameters = connectionUrl.getContainerParameters();
                ServiceLoader<JdbcDatabaseContainerProvider> databaseContainers = ServiceLoader.load(JdbcDatabaseContainerProvider.class);
                for (JdbcDatabaseContainerProvider candidateContainerType : databaseContainers) {
                    if (!candidateContainerType.supports(connectionUrl.getDatabaseType())) continue;
                    container = candidateContainerType.newInstance(connectionUrl);
                    container.withTmpFs(connectionUrl.getTmpfsOptions());
                    this.delegate = container.getJdbcDriverInstance();
                }
                if (container == null) {
                    throw new UnsupportedOperationException("Database name " + connectionUrl.getDatabaseType() + " not supported");
                }
                jdbcUrlContainerCache.put(url, container);
                container.setParameters(parameters);
                container.start();
            }
            Connection connection = container.createConnection(queryString);
            if (!initializedContainers.contains(container.getContainerId())) {
                JdbcDatabaseDelegate databaseDelegate = new JdbcDatabaseDelegate(container, queryString);
                this.runInitScriptIfRequired(connectionUrl, (DatabaseDelegate)databaseDelegate);
                this.runInitFunctionIfRequired(connectionUrl, connection);
                initializedContainers.add(container.getContainerId());
            }
            return this.wrapConnection(connection, container, connectionUrl);
        }
    }

    private Connection wrapConnection(Connection connection, JdbcDatabaseContainer container, ConnectionUrl connectionUrl) {
        boolean isDaemon = connectionUrl.isInDaemonMode() || connectionUrl.isReusable();
        Set connections = containerConnections.computeIfAbsent(container.getContainerId(), k -> new HashSet());
        connections.add(connection);
        Set finalConnections = connections;
        return new ConnectionWrapper(connection, () -> {
            finalConnections.remove(connection);
            if (!isDaemon && finalConnections.isEmpty()) {
                container.stop();
                jdbcUrlContainerCache.remove(connectionUrl.getUrl());
            }
        });
    }

    private void runInitScriptIfRequired(ConnectionUrl connectionUrl, DatabaseDelegate databaseDelegate) throws SQLException {
        if (connectionUrl.getInitScriptPath().isPresent()) {
            String initScriptPath = connectionUrl.getInitScriptPath().get();
            try {
                URL resource = initScriptPath.startsWith(FILE_PATH_PREFIX) ? new URL(initScriptPath) : Thread.currentThread().getContextClassLoader().getResource(initScriptPath);
                if (resource == null) {
                    LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
                    throw new SQLException("Could not load classpath init script: " + initScriptPath + ". Resource not found.");
                }
                String sql = IOUtils.toString((URL)resource, (Charset)StandardCharsets.UTF_8);
                ScriptUtils.executeDatabaseScript((DatabaseDelegate)databaseDelegate, (String)initScriptPath, (String)sql);
            }
            catch (IOException e) {
                LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
                throw new SQLException("Could not load classpath init script: " + initScriptPath, e);
            }
            catch (ScriptException e) {
                LOGGER.error("Error while executing init script: {}", (Object)initScriptPath, (Object)e);
                throw new SQLException("Error while executing init script: " + initScriptPath, e);
            }
        }
    }

    private void runInitFunctionIfRequired(ConnectionUrl connectionUrl, Connection connection) throws SQLException {
        if (connectionUrl.getInitFunction().isPresent()) {
            String className = connectionUrl.getInitFunction().get().getClassName();
            String methodName = connectionUrl.getInitFunction().get().getMethodName();
            try {
                Class<?> initFunctionClazz = Class.forName(className);
                Method method = initFunctionClazz.getMethod(methodName, Connection.class);
                method.invoke(null, connection);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error("Error while executing init function: {}::{}", new Object[]{className, methodName, e});
                throw new SQLException("Error while executing init function: " + className + "::" + methodName, e);
            }
        }
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.delegate.getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return this.delegate.jdbcCompliant();
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killContainers() {
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            jdbcUrlContainerCache.values().forEach(GenericContainer::stop);
            jdbcUrlContainerCache.clear();
            containerConnections.clear();
            initializedContainers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killContainer(String jdbcUrl) {
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            JdbcDatabaseContainer container = jdbcUrlContainerCache.get(jdbcUrl);
            if (container != null) {
                container.stop();
                jdbcUrlContainerCache.remove(jdbcUrl);
                containerConnections.remove(container.getContainerId());
                initializedContainers.remove(container.getContainerId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JdbcDatabaseContainer getContainer(String jdbcUrl) {
        Map<String, JdbcDatabaseContainer> map = jdbcUrlContainerCache;
        synchronized (map) {
            return jdbcUrlContainerCache.get(jdbcUrl);
        }
    }

    static {
        ContainerDatabaseDriver.load();
    }
}

