/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class MongoDBContainer
extends GenericContainer<MongoDBContainer> {
    private static final Logger log = LoggerFactory.getLogger(MongoDBContainer.class);
    private static final int CONTAINER_EXIT_CODE_OK = 0;
    private static final int MONGODB_INTERNAL_PORT = 27017;
    private static final int AWAIT_INIT_REPLICA_SET_ATTEMPTS = 60;
    private static final String MONGODB_VERSION_DEFAULT = "4.0.10";
    private static final String MONGODB_DATABASE_NAME_DEFAULT = "test";

    public MongoDBContainer() {
        this("mongo:4.0.10");
    }

    public MongoDBContainer(@NonNull String dockerImageName) {
        super(dockerImageName);
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
        this.withExposedPorts(new Integer[]{27017});
        this.withCommand(new String[]{"--replSet", "docker-rs"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*waiting for connections on port.*", (int)1));
    }

    public String getReplicaSetUrl() {
        if (!this.isRunning()) {
            throw new IllegalStateException("MongoDBContainer should be started first");
        }
        return String.format("mongodb://%s:%d/%s", this.getContainerIpAddress(), this.getMappedPort(27017), MONGODB_DATABASE_NAME_DEFAULT);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.initReplicaSet();
    }

    private String[] buildMongoEvalCommand(String command) {
        return new String[]{"mongo", "--eval", command};
    }

    private void checkMongoNodeExitCode(Container.ExecResult execResult) {
        if (execResult.getExitCode() != 0) {
            String errorMessage = String.format("An error occurred: %s", execResult.getStdout());
            log.error(errorMessage);
            throw new ReplicaSetInitializationException(errorMessage);
        }
    }

    private String buildMongoWaitCommand() {
        return String.format("var attempt = 0; while(%s) { if (attempt > %d) {quit(1);} print('%s ' + attempt); sleep(100);  attempt++;  }", "db.runCommand( { isMaster: 1 } ).ismaster==false", 60, "An attempt to await for a single node replica set initialization:");
    }

    private void checkMongoNodeExitCodeAfterWaiting(Container.ExecResult execResultWaitForMaster) {
        if (execResultWaitForMaster.getExitCode() != 0) {
            String errorMessage = String.format("A single node replica set was not initialized in a set timeout: %d attempts", 60);
            log.error(errorMessage);
            throw new ReplicaSetInitializationException(errorMessage);
        }
    }

    private void initReplicaSet() {
        log.debug("Initializing a single node node replica set...");
        Container.ExecResult execResultInitRs = this.execInContainer(this.buildMongoEvalCommand("rs.initiate();"));
        log.debug(execResultInitRs.getStdout());
        this.checkMongoNodeExitCode(execResultInitRs);
        log.debug("Awaiting for a single node replica set initialization up to {} attempts", (Object)60);
        Container.ExecResult execResultWaitForMaster = this.execInContainer(this.buildMongoEvalCommand(this.buildMongoWaitCommand()));
        log.debug(execResultWaitForMaster.getStdout());
        this.checkMongoNodeExitCodeAfterWaiting(execResultWaitForMaster);
    }

    public static class ReplicaSetInitializationException
    extends RuntimeException {
        ReplicaSetInitializationException(String errorMessage) {
            super(errorMessage);
        }
    }
}

