/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.redpanda;

import com.github.dockerjava.api.command.InspectContainerResponse;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;

public class RedpandaContainer
extends GenericContainer<RedpandaContainer> {
    private static final String REDPANDA_FULL_IMAGE_NAME = "docker.redpanda.com/vectorized/redpanda";
    private static final DockerImageName REDPANDA_IMAGE = DockerImageName.parse((String)"docker.redpanda.com/vectorized/redpanda");
    private static final int REDPANDA_PORT = 9092;
    private static final int SCHEMA_REGISTRY_PORT = 8081;
    private static final String STARTER_SCRIPT = "/testcontainers_start.sh";

    public RedpandaContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public RedpandaContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{REDPANDA_IMAGE});
        boolean isLessThanBaseVersion = new ComparableVersion(imageName.getVersionPart()).isLessThan("v22.2.1");
        if (REDPANDA_FULL_IMAGE_NAME.equals(imageName.getUnversionedPart()) && isLessThanBaseVersion) {
            throw new IllegalArgumentException("Redpanda version must be >= v22.2.1");
        }
        this.withExposedPorts(new Integer[]{9092, 8081});
        this.withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"sh"}));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Started Kafka API server.*", (int)1));
        this.withCommand(new String[]{"-c", "while [ ! -f /testcontainers_start.sh ]; do sleep 0.1; done; /testcontainers_start.sh"});
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        super.containerIsStarting(containerInfo);
        String command = "#!/bin/bash\n";
        command = command + "/usr/bin/rpk redpanda start --mode dev-container ";
        command = command + "--kafka-addr PLAINTEXT://0.0.0.0:29092,OUTSIDE://0.0.0.0:9092 ";
        command = command + "--advertise-kafka-addr PLAINTEXT://127.0.0.1:29092,OUTSIDE://" + this.getHost() + ":" + this.getMappedPort(9092);
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9092));
    }

    public String getSchemaRegistryAddress() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8081));
    }
}

