/*
 * Decompiled with CFR 0.152.
 */
package org.testfx.api;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.scene.Node;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.testfx.api.FxAssertContext;
import org.testfx.matcher.base.GeneralMatchers;
import org.testfx.service.finder.NodeFinder;
import org.testfx.service.query.NodeQuery;

public final class FxAssert {
    private static FxAssertContext context;

    public static <T> void verifyThat(T value, Matcher<? super T> matcher) {
        FxAssert.verifyThatImpl("", value, matcher, Function.identity());
    }

    public static <T> void verifyThat(T value, Matcher<? super T> matcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", value, matcher, errorMessageMapper);
    }

    public static <T extends Node> void verifyThat(T node, Matcher<T> nodeMatcher) {
        FxAssert.verifyThatImpl("", node, nodeMatcher, Function.identity());
    }

    public static <T extends Node> void verifyThat(T node, Matcher<T> nodeMatcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", node, nodeMatcher, errorMessageMapper);
    }

    public static <T extends Node> void verifyThatIter(Iterable<T> nodes, Matcher<Iterable<T>> nodesMatcher) {
        FxAssert.verifyThatImpl("", nodes, nodesMatcher, Function.identity());
    }

    public static <T extends Node> void verifyThatIter(Iterable<T> nodes, Matcher<Iterable<T>> nodesMatcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", nodes, nodesMatcher, errorMessageMapper);
    }

    public static <T extends Node> void verifyThat(String nodeQuery, Matcher<T> nodeMatcher) {
        FxAssert.verifyThatImpl("", FxAssert.toNode(nodeQuery), nodeMatcher, Function.identity());
    }

    public static <T extends Node> void verifyThat(String nodeQuery, Matcher<T> nodeMatcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", FxAssert.toNode(nodeQuery), nodeMatcher, errorMessageMapper);
    }

    public static <T extends Node> void verifyThatIter(String nodeQuery, Matcher<Iterable<T>> nodesMatcher) {
        FxAssert.verifyThatImpl("", FxAssert.toNodeSet(nodeQuery), nodesMatcher, Function.identity());
    }

    public static <T extends Node> void verifyThatIter(String nodeQuery, Matcher<Iterable<T>> nodesMatcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", FxAssert.toNodeSet(nodeQuery), nodesMatcher, errorMessageMapper);
    }

    public static <T extends Node> void verifyThat(NodeQuery nodeQuery, Matcher<T> nodeMatcher) {
        FxAssert.verifyThatImpl("", nodeQuery.query(), nodeMatcher, Function.identity());
    }

    public static <T extends Node> void verifyThat(NodeQuery nodeQuery, Matcher<T> nodeMatcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", nodeQuery.query(), nodeMatcher, errorMessageMapper);
    }

    public static <T extends Node> void verifyThatIter(NodeQuery nodeQuery, Matcher<Iterable<T>> nodesMatcher) {
        FxAssert.verifyThatImpl("", nodeQuery.queryAll(), nodesMatcher, Function.identity());
    }

    public static <T extends Node> void verifyThatIter(NodeQuery nodeQuery, Matcher<Iterable<T>> nodesMatcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", nodeQuery.queryAll(), nodesMatcher, errorMessageMapper);
    }

    public static <T extends Node> void verifyThat(T node, Predicate<T> nodePredicate) {
        FxAssert.verifyThatImpl("", node, FxAssert.toNodeMatcher(nodePredicate), Function.identity());
    }

    public static <T extends Node> void verifyThat(T node, Predicate<T> nodePredicate, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", node, FxAssert.toNodeMatcher(nodePredicate), errorMessageMapper);
    }

    public static <T extends Node> void verifyThat(String nodeQuery, Predicate<T> nodePredicate) {
        FxAssert.verifyThatImpl("", FxAssert.toNode(nodeQuery), FxAssert.toNodeMatcher(nodePredicate), Function.identity());
    }

    public static <T extends Node> void verifyThat(String nodeQuery, Predicate<T> nodePredicate, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", FxAssert.toNode(nodeQuery), FxAssert.toNodeMatcher(nodePredicate), errorMessageMapper);
    }

    public static <T extends Node> void verifyThat(NodeQuery nodeQuery, Predicate<T> nodePredicate) {
        FxAssert.verifyThatImpl("", nodeQuery.query(), FxAssert.toNodeMatcher(nodePredicate), Function.identity());
    }

    public static <T extends Node> void verifyThat(NodeQuery nodeQuery, Predicate<T> nodePredicate, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        FxAssert.verifyThatImpl("", nodeQuery.query(), FxAssert.toNodeMatcher(nodePredicate), errorMessageMapper);
    }

    public static FxAssertContext assertContext() {
        if (context == null) {
            context = new FxAssertContext();
        }
        return context;
    }

    private static <T> void verifyThatImpl(String reason, T value, Matcher<? super T> matcher, Function<StringBuilder, StringBuilder> errorMessageMapper) {
        try {
            MatcherAssert.assertThat((String)reason, value, matcher);
        }
        catch (AssertionError error) {
            StringBuilder sb = new StringBuilder(((Throwable)((Object)error)).getMessage());
            throw new AssertionError(errorMessageMapper.apply(sb));
        }
    }

    private static <T extends Node> T toNode(String nodeQuery) {
        NodeFinder nodeFinder = FxAssert.assertContext().getNodeFinder();
        return nodeFinder.lookup(nodeQuery).query();
    }

    private static <T extends Node> Set<T> toNodeSet(String nodeQuery) {
        NodeFinder nodeFinder = FxAssert.assertContext().getNodeFinder();
        return nodeFinder.lookup(nodeQuery).queryAll();
    }

    private static <T extends Node> Matcher<T> toNodeMatcher(Predicate<T> nodePredicate) {
        return GeneralMatchers.baseMatcher("applies on Predicate", nodePredicate);
    }
}

